/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions.cache;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKey;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
public class ConditionCacheKeys {
    private static final String PROJECT_PERMISSION_PREFIX = "atl.jira.permission.project.request.cache";
    private static final String GLOBAL_PERMISSION_PREFIX = "atl.jira.permission.global.request.cache";
    private static final String CUSTOM_CONDITION_PREFIX = "atl.jira.condition.custom.request.cache";
    private static final char CACHE_KEY_SEPARATOR = ':';

    @Nonnull
    @ExperimentalApi
    public static ConditionCacheKey permission(ProjectPermissionKey permission, @Nullable ApplicationUser user, Object ... args) {
        return ConditionCacheKeys.cacheKey(PROJECT_PERMISSION_PREFIX, permission.permissionKey(), user, args);
    }

    @Nonnull
    @ExperimentalApi
    public static ConditionCacheKey permission(GlobalPermissionKey permission, @Nullable ApplicationUser user, Object ... args) {
        return ConditionCacheKeys.cacheKey(GLOBAL_PERMISSION_PREFIX, permission.getKey(), user, args);
    }

    @Nonnull
    @ExperimentalApi
    public static ConditionCacheKey custom(String conditionName, ApplicationUser user, Object ... args) {
        return ConditionCacheKeys.cacheKey(CUSTOM_CONDITION_PREFIX, conditionName, user, args);
    }

    private static ConditionCacheKey cacheKey(String prefix, String mainComponent, ApplicationUser user, Object ... args) {
        return new ConditionCacheKey(prefix + ":" + mainComponent + ":" + String.valueOf(user) + String.valueOf(args != null ? ":" + StringUtils.join((Object[])args, (char)':') : Character.valueOf(':')));
    }
}

