/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionScheme;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public final class PermissionSchemeInput {
    private final String name;
    private final String description;
    private final List<PermissionGrantInput> permissions;

    private PermissionSchemeInput(String name, String description, Iterable<PermissionGrantInput> permissions) {
        this.name = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)name));
        this.description = description;
        this.permissions = permissions != null ? ImmutableList.copyOf(permissions) : Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public Option<String> getDescription() {
        return Option.option((Object)this.description);
    }

    public List<PermissionGrantInput> getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionSchemeInput that = (PermissionSchemeInput)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.permissions, that.permissions);
    }

    public static Builder builder(@Nonnull String name) {
        return new Builder(name);
    }

    public static Builder builder(@Nonnull PermissionSchemeInput data) {
        return new Builder(data);
    }

    public static Builder builder(@Nonnull PermissionScheme scheme) {
        return new Builder(scheme);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description, this.permissions});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("description", (Object)this.description).add("permissions", this.permissions).toString();
    }

    public static class Builder {
        private String name;
        private String description;
        private Set<PermissionGrantInput> permissions = Sets.newLinkedHashSet();

        public Builder(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        public Builder(PermissionSchemeInput schemeData) {
            this.name = schemeData.getName();
            this.description = (String)schemeData.getDescription().getOrNull();
            this.setPermissions(schemeData.getPermissions());
        }

        public Builder(PermissionScheme scheme) {
            this.name = scheme.getName();
            this.description = Strings.emptyToNull((String)scheme.getDescription());
            this.setOriginalPermissions(scheme.getPermissions());
        }

        public Builder setName(@Nonnull String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setPermissions(Iterable<PermissionGrantInput> permissions) {
            this.permissions.clear();
            return this.addPermissions(permissions);
        }

        public Builder setOriginalPermissions(Iterable<PermissionGrant> permissions) {
            this.permissions.clear();
            return this.addPermissions(Iterables.transform(permissions, (Function)new Function<PermissionGrant, PermissionGrantInput>(){

                public PermissionGrantInput apply(PermissionGrant input) {
                    return PermissionGrantInput.newGrant(input.getHolder(), input.getPermission());
                }
            }));
        }

        public Builder addPermissions(Iterable<PermissionGrantInput> permissions) {
            for (PermissionGrantInput permission : permissions) {
                this.permissions.add(permission);
            }
            return this;
        }

        public Builder addPermission(PermissionGrantInput permissions) {
            return this.addPermissions(Collections.singleton(permissions));
        }

        public PermissionSchemeInput build() {
            return new PermissionSchemeInput(this.name, this.description, this.permissions);
        }
    }
}

