/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.util.JqlIssueKeySupport;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.lucenelegacy.NumberTools;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
@Internal
public class IssueIdClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(IssueIdClauseQueryFactory.class);
    private final JqlOperandResolver operandResolver;
    private final JqlIssueKeySupport issueKeySupport;
    private final JqlIssueSupport issueSupport;

    public IssueIdClauseQueryFactory(JqlOperandResolver operandResolver, JqlIssueKeySupport issueKeySupport, JqlIssueSupport issueSupport) {
        this.issueSupport = Assertions.notNull("issueSupport", issueSupport);
        this.issueKeySupport = Assertions.notNull("issueKeySupport", issueKeySupport);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
    }

    @Override
    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Assertions.notNull("queryCreationContext", queryCreationContext);
        Operand operand = terminalClause.getOperand();
        Operator operator = terminalClause.getOperator();
        if (OperatorClasses.EMPTY_ONLY_OPERATORS.contains((Object)operator) && !operand.equals(EmptyOperand.EMPTY)) {
            return QueryFactoryResult.createFalseResult();
        }
        List<QueryLiteral> literals = this.operandResolver.getValues(queryCreationContext, operand, terminalClause);
        if (literals == null) {
            log.debug(String.format("Unable to find operand values from operand '%s' for clause '%s'.", operand.getDisplayString(), terminalClause.getName()));
            return QueryFactoryResult.createFalseResult();
        }
        if (this.isEqualityOperator(operator)) {
            return this.handleEquals(literals);
        }
        if (this.isNegationOperator(operator)) {
            return this.handleNotEquals(literals);
        }
        if (OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator)) {
            if (this.operandResolver.isListOperand(operand)) {
                log.debug(String.format("Tried to use list operand '%s' with relational operator '%s' in clause '%s'.", operand.getDisplayString(), operator.getDisplayString(), terminalClause.getName()));
                return QueryFactoryResult.createFalseResult();
            }
            QueryLiteral literal = this.operandResolver.getSingleValue(queryCreationContext.getApplicationUser(), operand, terminalClause);
            return this.handleRelational(queryCreationContext.getApplicationUser(), queryCreationContext.isSecurityOverriden(), operator, literal, terminalClause);
        }
        log.debug(String.format("The '%s' clause does not support the %s operator.", new Object[]{terminalClause.getName(), operator}));
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult handleRelational(ApplicationUser user, boolean overrideSecurity, Operator operator, QueryLiteral literal, TerminalClause clause) {
        return this.handleRelational(user, overrideSecurity, literal, clause, IssueIdClauseQueryFactory.createRangeQueryGenerator(operator));
    }

    private QueryFactoryResult handleRelational(ApplicationUser user, boolean overrideSecurity, QueryLiteral literal, TerminalClause clause, RangeQueryGenerator rangeQueryGenerator) {
        Issue issue;
        if (literal.isEmpty()) {
            log.debug(String.format("Encountered EMPTY literal from operand '%s' for operator '%s' on clause '%s'. Ignoring.", clause.getOperand().getDisplayString(), clause.getOperator().getDisplayString(), clause.getName()));
        }
        if (literal.getLongValue() != null) {
            issue = overrideSecurity ? this.issueSupport.getIssue(literal.getLongValue()) : this.issueSupport.getIssue(literal.getLongValue(), user);
        } else if (literal.getStringValue() != null) {
            issue = overrideSecurity ? this.issueSupport.getIssue(literal.getStringValue()) : this.issueSupport.getIssue(literal.getStringValue(), user);
        } else {
            log.debug(String.format("Encountered weird literal from operand '%s' for operator '%s' on clause '%s'. Ignoring.", clause.getOperand().getDisplayString(), clause.getOperator().getDisplayString(), clause.getName()));
            issue = null;
        }
        if (issue != null) {
            long currentCount = this.issueKeySupport.parseKeyNum(issue.getKey());
            if (currentCount < 0L) {
                return QueryFactoryResult.createFalseResult();
            }
            BooleanQuery.Builder subQuery = new BooleanQuery.Builder();
            subQuery.add(rangeQueryGenerator.get(currentCount), BooleanClause.Occur.MUST);
            subQuery.add(IssueIdClauseQueryFactory.createProjectQuery(issue.getProjectObject()), BooleanClause.Occur.FILTER);
            return new QueryFactoryResult((Query)subQuery.build());
        }
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult handleNotEquals(List<QueryLiteral> rawValues) {
        return new QueryFactoryResult(this.createPositiveEqualsQuery(rawValues), true);
    }

    private QueryFactoryResult handleEquals(List<QueryLiteral> rawValues) {
        return new QueryFactoryResult(this.createPositiveEqualsQuery(rawValues));
    }

    private Query createPositiveEqualsQuery(List<QueryLiteral> rawValues) {
        if (rawValues.size() == 1) {
            return this.createSingleValueQuery(rawValues.get(0));
        }
        return this.createMultiValuePositiveEqualsQuery(rawValues);
    }

    private Query createMultiValuePositiveEqualsQuery(List<QueryLiteral> rawValues) {
        List bytesRefs = rawValues.stream().map(this::toBytesRef).filter(Objects::nonNull).collect(Collectors.toList());
        return new TermInSetQuery(SystemSearchConstants.forIssueId().getIndexField(), bytesRefs);
    }

    @Nullable
    private BytesRef toBytesRef(QueryLiteral rawValue) {
        if (rawValue.isEmpty()) {
            return null;
        }
        if (rawValue.getStringValue() != null) {
            return this.issueKeyToBytesRef(rawValue);
        }
        return this.issueIdToBytesRef(rawValue);
    }

    private BytesRef issueIdToBytesRef(QueryLiteral rawValue) {
        return new BytesRef((CharSequence)rawValue.asString());
    }

    @Nullable
    private BytesRef issueKeyToBytesRef(QueryLiteral rawValue) {
        Issue issue = this.issueSupport.getIssue(rawValue.getStringValue());
        if (issue != null) {
            return new BytesRef((CharSequence)issue.getId().toString());
        }
        return null;
    }

    private Query createSingleValueQuery(QueryLiteral rawValue) {
        if (!rawValue.isEmpty()) {
            return this.createQueryForNotEmptyValue(rawValue);
        }
        return new BooleanQuery.Builder().build();
    }

    private Query createQueryForNotEmptyValue(QueryLiteral rawValue) {
        if (rawValue.getStringValue() != null) {
            return this.createQueryForKey(rawValue.getStringValue());
        }
        return this.createQueryForId(rawValue.asString());
    }

    private Query createQueryForKey(String issueKey) {
        Issue issue = this.issueSupport.getIssue(issueKey);
        if (issue != null) {
            return this.createQueryForId(issue.getId().toString());
        }
        return new BooleanQuery.Builder().build();
    }

    private Query createQueryForId(String id) {
        String fieldName = SystemSearchConstants.forIssueId().getIndexField();
        return new TermQuery(new Term(fieldName, id));
    }

    private static Query createProjectQuery(Project project) {
        return new TermQuery(new Term(SystemSearchConstants.forProject().getIndexField(), project.getId().toString()));
    }

    private static Query createRangeQuery(long min, long max, boolean minInclusive, boolean maxInclusive) {
        return new TermRangeQuery(SystemSearchConstants.forIssueKey().getKeyIndexOrderField(), IssueIdClauseQueryFactory.processRangeLong(min), IssueIdClauseQueryFactory.processRangeLong(max), minInclusive, maxInclusive);
    }

    private static BytesRef processRangeLong(long value) {
        if (value < 0L) {
            return null;
        }
        return new BytesRef((CharSequence)NumberTools.longToString((long)value));
    }

    private boolean isNegationOperator(Operator operator) {
        return operator == Operator.NOT_EQUALS || operator == Operator.NOT_IN || operator == Operator.IS_NOT;
    }

    private boolean isEqualityOperator(Operator operator) {
        return operator == Operator.EQUALS || operator == Operator.IN || operator == Operator.IS;
    }

    private static QueryFactoryResult createResult(List<BooleanClause> clauses) {
        if (clauses.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        if (clauses.size() == 1) {
            return new QueryFactoryResult(clauses.get(0).getQuery());
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        for (BooleanClause clause : clauses) {
            query.add(clause);
        }
        return new QueryFactoryResult((Query)query.build());
    }

    private static RangeQueryGenerator createRangeQueryGenerator(Operator operator) {
        switch (operator) {
            case LESS_THAN: {
                return new RangeQueryGenerator(){

                    @Override
                    public Query get(long limit) {
                        return IssueIdClauseQueryFactory.createRangeQuery(-1L, limit, true, false);
                    }
                };
            }
            case LESS_THAN_EQUALS: {
                return new RangeQueryGenerator(){

                    @Override
                    public Query get(long limit) {
                        return IssueIdClauseQueryFactory.createRangeQuery(-1L, limit, true, true);
                    }
                };
            }
            case GREATER_THAN: {
                return new RangeQueryGenerator(){

                    @Override
                    public Query get(long limit) {
                        return IssueIdClauseQueryFactory.createRangeQuery(limit, -1L, false, true);
                    }
                };
            }
            case GREATER_THAN_EQUALS: {
                return new RangeQueryGenerator(){

                    @Override
                    public Query get(long limit) {
                        return IssueIdClauseQueryFactory.createRangeQuery(limit, -1L, true, true);
                    }
                };
            }
        }
        throw new IllegalArgumentException("Unsupported Operator:" + String.valueOf((Object)operator));
    }

    private static interface RangeQueryGenerator {
        public Query get(long var1);
    }
}

