/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

@PublicSpi
public abstract class AbstractCustomFieldIndexer
implements FieldIndexer {
    private final FieldVisibilityManager fieldVisibilityManager;
    protected final CustomField customField;

    protected AbstractCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.customField = customField;
    }

    @Override
    public String getId() {
        return this.customField.getId();
    }

    @Override
    public String getDocumentFieldId() {
        return this.customField.getId();
    }

    @Deprecated
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        throw new UnsupportedOperationException();
    }

    protected void addDocumentFieldsSearchable(Document doc, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        this.addDocumentFieldsSearchable(doc, issue);
    }

    protected void addDocumentFieldsNotSearchable(Document doc, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        this.addDocumentFieldsNotSearchable(doc, issue);
    }

    @Override
    public final void addIndex(Document doc, Issue issue) {
        if (this.isFieldVisibleAndInScope(issue)) {
            this.addDocumentFieldsSearchable(doc, issue);
        } else {
            this.addDocumentFieldsNotSearchable(doc, issue);
        }
    }

    @Override
    public void addIndex(Document doc, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        if (this.isFieldVisibleAndInScope(issue)) {
            this.addDocumentFieldsSearchable(doc, issue, prefetchedData);
        } else {
            this.addDocumentFieldsNotSearchable(doc, issue, prefetchedData);
        }
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.fieldVisibilityManager.isFieldVisible(this.getId(), issue) && this.isRelevantForIssue(issue);
    }

    protected boolean isRelevantForIssue(Issue issue) {
        return this.customField.isRelevantForIssueContext(issue);
    }
}

