/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.serializer.StreamingCommentsJsonBeanSerializer;
import com.atlassian.jira.user.ApplicationUser;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using=StreamingCommentsJsonBeanSerializer.class)
public class StreamingCommentsJsonBean {
    private final Issue issue;
    private final boolean isRendered;
    private final String rendererType;
    private final ApplicationUser contextUser;
    private final int limit;
    private boolean firstPage = true;
    static final Integer DEFAULT_COMMENTS_PAGE_SIZE = 1000;
    public static final String EMBEDDED_COMMENTS_BACKGROUND_LIMIT = "jira.safeguards.webhooks.issue.comments.page";

    @Deprecated
    public StreamingCommentsJsonBean(Issue issue, boolean isRendered, String rendererType) {
        this(issue, isRendered, rendererType, null, DEFAULT_COMMENTS_PAGE_SIZE, false);
    }

    public StreamingCommentsJsonBean(Issue issue, boolean isRendered, String rendererType, ApplicationUser contextUser, ApplicationProperties applicationProperties, boolean isBackgroundProcessing) {
        this(issue, isRendered, rendererType, contextUser, StreamingCommentsJsonBean.provideEffectiveLimit(applicationProperties, isBackgroundProcessing), !isBackgroundProcessing);
    }

    @VisibleForTesting
    protected StreamingCommentsJsonBean(Issue issue, boolean isRendered, String rendererType, ApplicationUser contextUser, int limit, boolean firstPage) {
        this.issue = issue;
        this.isRendered = isRendered;
        this.rendererType = rendererType;
        this.contextUser = contextUser;
        this.limit = limit;
        this.firstPage = firstPage;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public boolean isRendered() {
        return this.isRendered;
    }

    public String getRendererType() {
        return this.rendererType;
    }

    public ApplicationUser getContextUser() {
        return this.contextUser;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isFirstPageRequested() {
        return this.firstPage;
    }

    private static int provideEffectiveLimit(ApplicationProperties applicationProperties, boolean isBackgroundProcessing) {
        try {
            int customLimit = Integer.parseInt(applicationProperties.getDefaultBackedString(isBackgroundProcessing ? EMBEDDED_COMMENTS_BACKGROUND_LIMIT : "jira.safeguards.rest.issue.comments.page"));
            return customLimit > 0 ? customLimit : DEFAULT_COMMENTS_PAGE_SIZE;
        }
        catch (NumberFormatException e) {
            return DEFAULT_COMMENTS_PAGE_SIZE;
        }
    }
}

