/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CloneOptionConfiguration;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
@PublicSpi
public interface CustomFieldType<T, S> {
    public static final String DEFAULT_VALUE_TYPE = "DefaultValue";
    public static final String RESOURCE_PREVIEW = "customfieldpreview.png";

    public void init(CustomFieldTypeModuleDescriptor var1);

    public String getKey();

    public String getName();

    public String getDescription();

    public CustomFieldTypeModuleDescriptor getDescriptor();

    public String getStringFromSingularObject(S var1);

    public S getSingularObjectFromString(String var1) throws FieldValidationException;

    public Set<Long> remove(CustomField var1);

    public void validateFromParams(CustomFieldParams var1, ErrorCollection var2, FieldConfig var3);

    default public boolean areAllRequiredParametersPresent(Map<String, Object> params, String customFieldId) {
        if (params.containsKey(customFieldId)) {
            CustomFieldParams customFieldParams = (CustomFieldParams)params.get(customFieldId);
            return this.getValueFromCustomFieldParams(customFieldParams) != null;
        }
        return false;
    }

    public void createValue(CustomField var1, Issue var2, @Nonnull T var3);

    public void updateValue(CustomField var1, Issue var2, T var3);

    public T getValueFromCustomFieldParams(CustomFieldParams var1) throws FieldValidationException;

    public Object getStringValueFromCustomFieldParams(CustomFieldParams var1);

    @Nullable
    public T getValueFromIssue(CustomField var1, Issue var2);

    public T getDefaultValue(FieldConfig var1);

    public void setDefaultValue(FieldConfig var1, T var2);

    @Nullable
    public String getChangelogValue(CustomField var1, T var2);

    @Nullable
    public String getChangelogString(CustomField var1, T var2);

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue var1, CustomField var2, FieldLayoutItem var3);

    @Nonnull
    public List<FieldConfigItemType> getConfigurationItemTypes();

    @Nullable
    public List<FieldIndexer> getRelatedIndexers(CustomField var1);

    public boolean isRenderable();

    public boolean valuesEqual(T var1, T var2);

    @Nullable
    public String availableForBulkEdit(BulkEditBean var1);

    @Nonnull
    default public CloneOptionConfiguration getCloneOptionConfiguration(CustomField field, Issue issueToClone) {
        return CloneOptionConfiguration.DO_NOT_DISPLAY;
    }

    @Nullable
    default public T getCloneValue(CustomField field, Issue issueToClone, Optional<Boolean> cloneOptionSelection) {
        boolean shouldClone = cloneOptionSelection.orElse(true);
        if (shouldClone) {
            return this.getValueFromIssue(field, issueToClone);
        }
        return null;
    }

    default public boolean isUserInputRequiredForMove(CustomFieldParams relevantParams, FieldConfig config, Long targetProjectId, String targetIssueTypeId) {
        return false;
    }

    @ExperimentalApi
    default public NonNullCustomFieldProvider getNonNullCustomFieldProvider() {
        return null;
    }

    @ExperimentalApi
    default public boolean requiresAdditionalParams() {
        return false;
    }
}

