/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.ofbiz.core.util.UtilDateTime;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@PublicApi
public class CreateAttachmentParamsBean {
    private final File file;
    private final String filename;
    private final String contentType;
    @Nullable
    private final ApplicationUser author;
    private final Issue issue;
    private final Boolean zip;
    private final Boolean thumbnailable;
    private final Map<String, Object> attachmentProperties;
    private final Date createdTime;
    private final Boolean copySourceFile;

    private CreateAttachmentParamsBean(Builder builder) {
        this.file = builder.file;
        this.filename = builder.filename;
        this.contentType = builder.contentType;
        this.author = builder.author;
        this.issue = builder.issue;
        this.zip = builder.zip;
        this.thumbnailable = builder.thumbnailable;
        this.attachmentProperties = builder.attachmentProperties;
        this.createdTime = builder.createdTime;
        this.copySourceFile = builder.copySourceFile;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public ApplicationUser getAuthor() {
        return this.author;
    }

    public Issue getIssue() {
        return this.issue;
    }

    @Nullable
    public Boolean getZip() {
        return this.zip;
    }

    @Nullable
    public Boolean getThumbnailable() {
        return this.thumbnailable;
    }

    @Nullable
    public Map<String, Object> getAttachmentProperties() {
        return this.attachmentProperties;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Nullable
    public Boolean getCopySourceFile() {
        return this.copySourceFile;
    }

    @ParametersAreNonnullByDefault
    @ReturnValuesAreNonnullByDefault
    public static class Builder {
        private File file;
        private String filename;
        private String contentType;
        @Nullable
        private ApplicationUser author;
        private Issue issue;
        private Boolean zip;
        private Boolean thumbnailable;
        private Map<String, Object> attachmentProperties;
        private Date createdTime = UtilDateTime.nowTimestamp();
        private Boolean copySourceFile = false;

        public Builder() {
        }

        public Builder(File file, String filename, @Nullable String contentType, @Nullable ApplicationUser author, Issue issue) {
            this.file = file;
            this.filename = filename;
            this.contentType = contentType;
            this.author = author;
            this.issue = issue;
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder contentType(@Nullable String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder author(@Nullable ApplicationUser author) {
            this.author = author;
            return this;
        }

        public Builder issue(Issue issue) {
            this.issue = issue;
            return this;
        }

        public Builder zip(@Nullable Boolean zip) {
            this.zip = zip;
            return this;
        }

        public Builder thumbnailable(@Nullable Boolean thumbnailable) {
            this.thumbnailable = thumbnailable;
            return this;
        }

        public Builder attachmentProperties(@Nullable Map<String, Object> attachmentProperties) {
            this.attachmentProperties = attachmentProperties;
            return this;
        }

        public Builder createdTime(Date createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder copySourceFile(@Nullable Boolean copySourceFile) {
            this.copySourceFile = copySourceFile;
            return this;
        }

        public CreateAttachmentParamsBean build() {
            Preconditions.checkNotNull((Object)this.file);
            Preconditions.checkNotNull((Object)this.filename);
            Preconditions.checkNotNull((Object)this.issue);
            return new CreateAttachmentParamsBean(this);
        }
    }
}

