/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.operation;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.event.operation.SpanningOperationType;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ExperimentalApi
public class SpanningOperation
implements Serializable {
    private final SpanningOperation parent;
    private final String type;
    private final String id;

    private SpanningOperation(@Nullable SpanningOperation parent, @Nonnull String type, @Nonnull String id) {
        this.parent = parent;
        this.type = Objects.requireNonNull(type);
        this.id = Objects.requireNonNull(id);
    }

    private SpanningOperation(Builder builder) {
        this(builder.parent, builder.type, builder.id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public SpanningOperation getParent() {
        return this.parent;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanningOperation that = (SpanningOperation)o;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.type, this.id);
    }

    public String toString() {
        return "SpanningOperation{parent=" + String.valueOf(this.parent) + ", type='" + this.type + "', id='" + this.id + "'}";
    }

    public static final class Builder {
        private SpanningOperation parent;
        private String type;
        private String id;

        private Builder() {
        }

        public Builder parent(SpanningOperation parent) {
            this.parent = parent;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder type(SpanningOperationType type) {
            this.type = type.toString();
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder generatedId() {
            this.id = UUID.randomUUID().toString();
            return this;
        }

        public SpanningOperation build() {
            return new SpanningOperation(this);
        }
    }
}

