/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.util.PathUtils;
import java.io.File;

@PublicApi
public interface IndexPathManager {
    public static final String INDEXES_DIR = JiraHome.INDEXES_DIR;

    public String getIndexRootPath();

    public String getIssueIndexPath();

    public String getCommentIndexPath();

    public String getWorklogIndexPath();

    public String getChangeHistoryIndexPath();

    public String getPluginIndexRootPath();

    public String getSharedEntityIndexPath();

    public static class PropertiesAdaptor
    implements IndexPathManager {
        private final JiraHome jiraHome;

        public PropertiesAdaptor(JiraHome jiraHome) {
            this.jiraHome = jiraHome;
        }

        @Override
        public String getIndexRootPath() {
            return new File(this.jiraHome.getLocalHomePath(), INDEXES_DIR).getAbsolutePath();
        }

        @Override
        public String getIssueIndexPath() {
            return PathUtils.joinPaths(this.getIndexRootPath(), "issues");
        }

        @Override
        public String getCommentIndexPath() {
            return PathUtils.joinPaths(this.getIndexRootPath(), "comments");
        }

        @Override
        public String getWorklogIndexPath() {
            return PathUtils.joinPaths(this.getIndexRootPath(), "worklogs");
        }

        @Override
        public String getChangeHistoryIndexPath() {
            return PathUtils.joinPaths(this.getIndexRootPath(), "changes");
        }

        @Override
        public String getSharedEntityIndexPath() {
            return PathUtils.joinPaths(this.getIndexRootPath(), "entities");
        }

        @Override
        public String getPluginIndexRootPath() {
            return PathUtils.joinPaths(this.getIndexRootPath(), "plugins");
        }
    }

    public static final class Directory {
        public static final String ISSUES_SUBDIR = "issues";
        public static final String COMMENTS_SUBDIR = "comments";
        public static final String PLUGINS_SUBDIR = "plugins";
        public static final String ENTITIES_SUBDIR = "entities";
        public static final String CHANGE_HISTORY_SUBDIR = "changes";
        public static final String WORKLOGS_SUBDIR = "worklogs";
    }
}

