/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;

public class UserHistoryItem
implements Serializable {
    private static final int VERY_SHORT = 10;
    public static final Type ADMIN_PAGE = new Type("AdminPage");
    public static final Type ASSIGNEE = new Type("Assignee");
    public static final Type DASHBOARD = new Type("Dashboard");
    public static final Type ISSUE = new Type("Issue");
    public static final Type ISSUELINKTYPE = new Type("IssueLink");
    public static final Type ISSUESEARCHER = new Type("Searcher");
    public static final Type JQL_QUERY = new Type("JQLQuery");
    public static final Type PROJECT = new Type("Project");
    public static final Type RESOLUTION = new Type("Resolution");
    public static final Type USED_USER = new Type("UsedUser");
    private static final Map<String, Type> KNOWN_TYPES = ImmutableMap.builder().put((Object)ADMIN_PAGE.getName(), (Object)ADMIN_PAGE).put((Object)ASSIGNEE.getName(), (Object)ASSIGNEE).put((Object)DASHBOARD.getName(), (Object)DASHBOARD).put((Object)ISSUE.getName(), (Object)ISSUE).put((Object)ISSUELINKTYPE.getName(), (Object)ISSUELINKTYPE).put((Object)ISSUESEARCHER.getName(), (Object)ISSUESEARCHER).put((Object)JQL_QUERY.getName(), (Object)JQL_QUERY).put((Object)PROJECT.getName(), (Object)PROJECT).put((Object)RESOLUTION.getName(), (Object)RESOLUTION).put((Object)USED_USER.getName(), (Object)USED_USER).build();
    public static final Function<UserHistoryItem, String> GET_ENTITY_ID = new Function<UserHistoryItem, String>(){

        @Nullable
        public String apply(@Nullable UserHistoryItem input) {
            return input == null ? null : input.getEntityId();
        }
    };
    private final long lastViewed;
    private final Type type;
    private final String entityId;
    private final String data;

    public UserHistoryItem(Type type, String entityId, long lastViewed, String data) {
        Assertions.notNull("type", type);
        Assertions.notNull("entityId", entityId);
        Assertions.notNull("lastViewed", lastViewed);
        this.type = type;
        this.entityId = entityId;
        this.lastViewed = lastViewed;
        this.data = data;
    }

    public UserHistoryItem(Type type, String entityId, long lastViewed) {
        this(type, entityId, lastViewed, null);
    }

    public UserHistoryItem(Type type, String entityId) {
        this(type, entityId, System.currentTimeMillis());
    }

    public UserHistoryItem(Type type, String entityId, String data) {
        this(type, entityId, System.currentTimeMillis(), data);
    }

    public long getLastViewed() {
        return this.lastViewed;
    }

    public Type getType() {
        return this.type;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserHistoryItem other = (UserHistoryItem)o;
        return this.entityId.equals(other.entityId) && this.lastViewed == other.lastViewed && this.type.equals(other.type);
    }

    public int hashCode() {
        int result = (int)(this.lastViewed ^ this.lastViewed >>> 32);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.entityId != null ? this.entityId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UserHistoryItem{type=" + this.type + ", entityId='" + this.entityId + "', lastViewed=" + this.lastViewed + "}";
    }

    public static class Type
    implements Serializable {
        private static final long serialVersionUID = 8237618370525069310L;
        private final String name;

        public Type(String name) {
            Assertions.notBlank("name", name);
            Assertions.is("name", name.length() <= 10);
            this.name = name;
        }

        public static Type getInstance(String name) {
            Type type = KNOWN_TYPES.get(name);
            if (type != null) {
                return type;
            }
            return new Type(name);
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name == null ? 0 : this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return Objects.equal((Object)this.name, (Object)((Type)obj).name);
        }

        public String toString() {
            return this.name;
        }
    }
}

