/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.rights.ShareRight;
import com.atlassian.jira.sharing.rights.ShareRights;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.util.dbc.Assertions;

public class SharePermissionImpl
implements SharePermission {
    private final Long id;
    private final ShareType.Name type;
    private final String param1;
    private final String param2;
    private final ShareRight rights;

    public SharePermissionImpl(Long id, ShareType.Name type, String param1, String param2, ShareRight rights) {
        Assertions.notNull("type", type);
        if (param1 == null && param2 != null) {
            throw new IllegalArgumentException("param2 can not be null when param1 is not.");
        }
        this.id = id;
        this.type = type;
        this.param1 = param1;
        this.param2 = param2;
        this.rights = rights;
    }

    @Deprecated
    public SharePermissionImpl(Long id, ShareType.Name type, String param1, String param2) {
        this(id, type, param1, param2, ShareRights.VIEW);
    }

    @Deprecated
    SharePermissionImpl(ShareType.Name type, String param2) {
        Assertions.notNull("type", type);
        Assertions.notNull("param2", param2);
        this.id = null;
        this.type = type;
        this.param1 = null;
        this.param2 = param2;
        this.rights = ShareRights.VIEW;
    }

    @Deprecated
    public SharePermissionImpl(ShareType.Name type, String param1, String param2) {
        this(null, type, param1, param2, ShareRights.VIEW);
    }

    public SharePermissionImpl(ShareType.Name type, String param1, String param2, ShareRight rights) {
        this(null, type, param1, param2, rights);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public ShareType.Name getType() {
        return this.type;
    }

    @Override
    public String getParam1() {
        return this.param1;
    }

    @Override
    public String getParam2() {
        return this.param2;
    }

    @Override
    public ShareRight getRights() {
        return this.rights == null ? ShareRights.VIEW : this.rights;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharePermissionImpl that = (SharePermissionImpl)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (this.param1 != null ? !this.param1.equals(that.param1) : that.param1 != null) {
            return false;
        }
        if (this.param2 != null ? !this.param2.equals(that.param2) : that.param2 != null) {
            return false;
        }
        return !(this.rights != null ? !this.rights.equals(that.rights) : that.rights != null);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.param1 != null ? this.param1.hashCode() : 0);
        result = 31 * result + (this.param2 != null ? this.param2.hashCode() : 0);
        result = 31 * result + (this.rights != null ? this.rights.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SharePermissionImpl{type=" + this.type + ", param1='" + this.param1 + "', param2='" + this.param2 + "', rights=" + this.rights + "}";
    }

    @Override
    public boolean isEdit() {
        return this.getRights().hasEditRightsGranted();
    }

    @Override
    public boolean isView() {
        return this.getRights().hasViewRightsGranted();
    }
}

