/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.PortUtil;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.auth.AuthenticationContextAware;
import com.google.common.annotations.VisibleForTesting;
import java.text.MessageFormat;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import org.apache.log4j.Logger;

class MailServicesHelper {
    private static final Logger LOG = ComponentAccessor.getComponent(MailLoggingManager.class).getIncomingMailChildLogger("mailfetcherservice");
    private final MailServer server;
    private final MessageHandlerErrorCollector monitor;

    static MailServicesHelper newInstance(MailServer server, MessageHandlerErrorCollector monitor) {
        return new MailServicesHelper(server, monitor);
    }

    private MailServicesHelper(MailServer server, MessageHandlerErrorCollector monitor) {
        this.server = server;
        this.monitor = monitor;
    }

    Optional<Store> getConnectedStore() {
        return this.server instanceof AuthenticationContextAware ? this.handleAuthAwareMailServer() : this.handleLegacyMailServer();
    }

    private Optional<Store> handleAuthAwareMailServer() {
        return this.getStoreOptional(this.server, this.monitor).map(this.connectUsing(arg_0 -> ((AuthenticationContextAware)((AuthenticationContextAware)this.server)).smartConnect(arg_0)));
    }

    private Optional<Store> handleLegacyMailServer() {
        String hostname = this.server.getHostname();
        String username = this.server.getUsername();
        String password = this.server.getPassword();
        if (hostname == null || username == null || password == null) {
            this.monitor.warning(MessageFormat.format("Cannot retrieve mail due to a missing parameter in Mail Server \"{0}\": [host,{1}],[username,{2}],[password,{3}]", this.server.getName(), hostname, username, Optional.ofNullable(password).map(s -> "***").orElse(null)));
            return Optional.empty();
        }
        int port = this.getPort(this.server);
        return this.getStoreOptional(this.server, this.monitor).map(this.connectUsing(s -> s.connect(hostname, port, username, password)));
    }

    private Function<Store, Store> connectUsing(StoreConnector<Store, MessagingException> storeConnector) {
        String hostname = this.server.getHostname();
        return store -> {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Connecting to mail store to host [" + hostname + "]"));
                }
                storeConnector.connect((Store)store);
                LOG.debug((Object)"Successfully connected to mail store");
                return store;
            }
            catch (MessagingException e) {
                String environmentInfo = MessageFormat.format("{0}: {1} while connecting to host \"{2}\" as user \"{3}\" via protocol \"{4}\"", ((Object)((Object)e)).getClass().getName(), e.getMessage(), hostname, this.server.getUsername(), this.server.getMailProtocol());
                if (LOG.isDebugEnabled()) {
                    this.monitor.warning(environmentInfo + ": " + e, e);
                } else {
                    Object cause = "";
                    if (e.getCause() != null) {
                        cause = ", caused by: " + e.getCause().toString();
                    }
                    this.monitor.warning(environmentInfo + (String)cause);
                }
                return null;
            }
        };
    }

    @VisibleForTesting
    Optional<Store> getStoreOptional(MailServer mailServer, MessageHandlerErrorCollector monitor) {
        String protocol = this.server.getMailProtocol().getProtocol();
        int port = this.getPort(mailServer);
        try {
            Session session = mailServer.getSession();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting store from the session using protocol [" + protocol + "]"));
            }
            return Optional.of(session.getStore(new URLName(protocol, null, port, null, null, null)));
        }
        catch (NoSuchProviderException e) {
            monitor.error("Error getting provider for protocol " + protocol + ": " + e, e);
        }
        catch (Exception e) {
            monitor.error("Cannot create mail session: " + e.getMessage(), e);
        }
        return Optional.empty();
    }

    @VisibleForTesting
    int getPort(MailServer server) {
        int parsedPort = PortUtil.parsePort(server.getPort());
        if (parsedPort >= 0) {
            return parsedPort;
        }
        LOG.error((Object)MessageFormat.format("Invalid port number: {0} for mail server: {1}. Using the default port for this service type.", server.getPort(), server.getId()));
        return -1;
    }

    private static interface StoreConnector<T, E extends Exception> {
        public void connect(T var1) throws E;
    }
}

