/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.request;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.field.NestedField;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Internal
abstract class AbstractSearchRequestBuilder<T extends AbstractSearchRequestBuilder<T>> {
    protected final Map<NestedField, ImmutableSet.Builder<Field>> nestedFields = new HashMap<NestedField, ImmutableSet.Builder<Field>>();
    protected final ImmutableList.Builder<Field> fields = ImmutableList.builder();

    AbstractSearchRequestBuilder() {
    }

    public final T fields(Field ... fields) {
        Objects.requireNonNull(fields, "fields");
        AbstractSearchRequestBuilder.maybeAdd(this.fields, Arrays.stream(fields).toList());
        return this.self();
    }

    public final T fields(Iterable<Field> fields) {
        Objects.requireNonNull(fields, "fields");
        AbstractSearchRequestBuilder.maybeAdd(this.fields, fields);
        return this.self();
    }

    public final T nestedFields(NestedField nestedField, Iterable<Field> fields) {
        Objects.requireNonNull(fields, "fields");
        ImmutableSet.Builder fieldBuilder = this.nestedFields.computeIfAbsent(Objects.requireNonNull(nestedField, "nestedFields"), name -> ImmutableSet.builder());
        AbstractSearchRequestBuilder.maybeAdd((ImmutableCollection.Builder<Field>)fieldBuilder, fields);
        return this.self();
    }

    protected abstract T self();

    private static void maybeAdd(ImmutableCollection.Builder<Field> builder, Iterable<Field> fields) {
        fields.forEach(field -> Optional.ofNullable(field).ifPresent(arg_0 -> ((ImmutableCollection.Builder)builder).add(arg_0)));
    }
}

