/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.util.JiraUrlCodec;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;

public class ResolutionJsonBean {
    @JsonProperty
    @Schema(example="http://www.example.com/jira/rest/api/2/resolution/1")
    private String self;
    @JsonProperty
    @Schema(example="1")
    private String id;
    @JsonProperty
    @Schema(example="Fixed")
    private String description;
    @JsonProperty
    @Schema(example="http://www.example.com/jira/images/icons/statuses/resolved.png")
    private String iconUrl;
    @JsonProperty
    @Schema(example="Fixed")
    private String name;

    public static Collection<ResolutionJsonBean> shortBeans(Collection<Resolution> resolutions, JiraBaseUrls urls) {
        ArrayList result = Lists.newArrayListWithCapacity((int)resolutions.size());
        for (Resolution from : resolutions) {
            result.add(ResolutionJsonBean.shortBean(from, urls));
        }
        return result;
    }

    public static ResolutionJsonBean shortBean(Resolution resolution, JiraBaseUrls urls) {
        if (resolution == null) {
            return null;
        }
        ResolutionJsonBean bean = new ResolutionJsonBean();
        bean.self = urls.restApi2BaseUrl() + "resolution/" + JiraUrlCodec.encode(resolution.getId().toString());
        bean.id = resolution.getId();
        bean.name = resolution.getNameTranslation();
        bean.description = resolution.getDescTranslation();
        return bean;
    }
}

