/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.board.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@ExperimentalApi
public class BoardColumn {
    private final Status name;
    private final List<Status> statuses;

    public BoardColumn(Status name, List<Status> statuses) {
        this.name = Assertions.notNull(name);
        this.statuses = ImmutableList.copyOf((Collection)Assertions.notNull(statuses));
    }

    public Status getName() {
        return this.name;
    }

    public List<Status> getStatuses() {
        return this.statuses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoardColumn that = (BoardColumn)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.statuses, that.statuses);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.statuses);
    }

    public String toString() {
        return "BoardColumn{name=" + this.name + ", statuses=" + this.statuses + "}";
    }
}

