/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.rest.entities;

import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.lang.reflect.Field;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="issue")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IssueEntity {
    private String uuid;
    private String udid;
    private String devName;
    private String systemName;
    private String systemVersion;
    private String language;
    private String model;
    private String appVersion;
    private String appVersionShort;
    private String appName;
    private String appId;
    private String description;
    private String summary;
    private String type;
    private boolean isCrash;
    private String[] components;

    public static IssueEntity fromJSONObj(JSONObject obj) throws JSONException {
        IssueEntity issue = new IssueEntity();
        for (Field field : IssueEntity.class.getDeclaredFields()) {
            if (!obj.has(field.getName())) continue;
            try {
                if (field.getType().equals(Boolean.TYPE)) {
                    field.set(issue, obj.getBoolean(field.getName()));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    field.set(issue, obj.getString(field.getName()));
                    continue;
                }
                if (!field.getType().equals(String[].class)) continue;
                JSONArray arr = obj.getJSONArray(field.getName());
                String[] strArr = new String[arr.length()];
                for (int i = 0; i < arr.length(); ++i) {
                    strArr[i] = arr.getString(i);
                }
                field.set(issue, strArr);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("static factory method should be able to set private fields of instance of containing class!");
            }
        }
        return issue;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getUdid() {
        return this.udid;
    }

    public String getDevName() {
        return this.devName;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getModel() {
        return this.model;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppVersionShort() {
        return this.appVersionShort;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDescription() {
        return IssueEntity.isEmpty(this.description) ? "<no comment>" : this.description;
    }

    private static boolean isEmpty(String text) {
        return StringUtils.isBlank(text) || StringUtils.isWhitespace(text);
    }

    public String getSummary() {
        return IssueEntity.isEmpty(this.summary) ? "<no title>" : this.summary;
    }

    public String getType() {
        return this.type;
    }

    public String[] getComponents() {
        return this.components;
    }

    public boolean isCrash() {
        return this.isCrash;
    }
}

