/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.tabpanel;

import com.atlassian.jconnect.jira.IssueHelper;
import com.atlassian.jconnect.jira.tabpanel.AbstractFragment;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.velocity.VelocityManager;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.awt.Color;
import java.awt.Paint;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public abstract class AbstractChartFragment
extends AbstractFragment {
    protected static final int WIDTH = 760;
    protected static final int HEIGHT = 250;
    private static final Logger log = Logger.getLogger((String)AbstractChartFragment.class.getName());
    private static final Color NICE_BLUE = new Color(51, 102, 204);
    private static final Color NICE_RED = new Color(220, 57, 18);
    private static final Color NICE_YELLOW = new Color(255, 153, 0);
    private static final Color NICE_GREEN = new Color(16, 150, 24);
    private static final Color NICE_VIOLET = new Color(153, 0, 153);
    private static final Color[] BAR_COLORS = new Color[]{NICE_BLUE, NICE_RED, NICE_YELLOW, NICE_GREEN, NICE_VIOLET};
    protected final SearchService searchService;

    public AbstractChartFragment(SearchService searchService, VelocityManager velocityManager, ApplicationProperties applicationProperites, JiraAuthenticationContext jiraAuthenticationContext) {
        super(velocityManager, applicationProperites, jiraAuthenticationContext);
        this.searchService = searchService;
    }

    @Override
    public final Map<String, Object> createVelocityParams(BrowseContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        List<Issue> issues = this.collectIssues(ctx, (ErrorCollection)errors);
        this.generateChart(params, issues, (ErrorCollection)errors);
        params.put("errors", errors);
        return params;
    }

    private List<Issue> collectIssues(BrowseContext ctx, ErrorCollection errors) {
        String jql = "project=" + ctx.getProject().getKey() + " order by createdDate";
        ApplicationUser loggedInUser = this.getJiraAuthenticationContext().getLoggedInUser();
        SearchService.ParseResult parseResult = this.searchService.parseQuery(loggedInUser, jql);
        if (!parseResult.isValid()) {
            errors.addErrorMessages((Collection)parseResult.getErrors().getErrorMessages());
        } else {
            try {
                SearchResults results = this.searchService.search(loggedInUser, parseResult.getQuery(), PagerFilter.newPageAlignedFilter((int)0, (int)500));
                return results.getIssues();
            }
            catch (SearchException se) {
                errors.addErrorMessage(se.getLocalizedMessage());
            }
        }
        return Collections.emptyList();
    }

    protected CategoryDataset createDataset(List<Issue> issues) {
        DefaultCategoryDataset answer = new DefaultCategoryDataset();
        for (Issue issue : issues) {
            String fieldValue = this.parseEnvironmentString(issue.getEnvironment());
            if (fieldValue == null) continue;
            fieldValue = fieldValue.trim();
            if (!answer.getColumnKeys().contains(fieldValue)) {
                answer.addValue(0.0, (Comparable)((Object)this.issueCountName()), (Comparable)((Object)fieldValue));
            }
            answer.incrementValue(1.0, (Comparable)((Object)this.issueCountName()), (Comparable)((Object)fieldValue));
        }
        return answer;
    }

    protected void generateChart(Map<String, Object> params, List<Issue> issues, ErrorCollection errors) {
        if (issues.isEmpty()) {
            return;
        }
        try {
            CategoryDataset dataset = this.createDataset(issues);
            JFreeChart chart = ChartFactory.createBarChart(null, (String)this.getText(this.i18nPrefix() + ".xaxistitle"), (String)this.issueCountName(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            chart.getCategoryPlot().setRenderer((CategoryItemRenderer)new CustomBarColorsRenderer(BAR_COLORS));
            chart.setBackgroundPaint((Paint)Color.white);
            chart.getCategoryPlot().getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            ChartHelper chartHelper = new ChartHelper(chart);
            chartHelper.generate(760, 250);
            params.put("chart", chartHelper.getLocation());
            params.put("imagemapName", chartHelper.getImageMapName());
            params.put("imageWidth", 760);
            params.put("imageHeight", 250);
            params.put("imageMap", new ChartImageMap(chartHelper));
        }
        catch (Exception e) {
            log.error((Object)"Error while creating chart", (Throwable)e);
            errors.addErrorMessage(this.getJiraAuthenticationContext().getI18nHelper().getText(this.i18nPrefix() + ".charterror", e.getMessage()));
        }
    }

    @Override
    public boolean showFragment(BrowseContext browseContext) {
        return true;
    }

    public abstract int groupNumber();

    public String i18nPrefix() {
        return "projecttabpanel." + this.getId();
    }

    protected String parseEnvironmentString(String environment) {
        if (environment == null || StringUtils.isEmpty(environment)) {
            return null;
        }
        Matcher matcher = IssueHelper.ENV_FIELD_PATTERN.matcher(environment);
        if (matcher.find()) {
            return matcher.group(this.groupNumber());
        }
        return this.getText(this.i18nPrefix() + ".unknown");
    }

    protected final String getText(String key) {
        return this.getJiraAuthenticationContext().getI18nHelper().getText(key);
    }

    public final String issueCountName() {
        return this.getText(this.i18nPrefix() + ".yaxistitle");
    }

    public static final class ChartImageMap {
        private final ChartHelper helper;

        public ChartImageMap(ChartHelper helper) {
            this.helper = helper;
        }

        public boolean hasImageMap() {
            return this.helper.getImageMap() != null;
        }

        @HtmlSafe
        public String getMapHtml() {
            return this.helper.getImageMap();
        }
    }

    private static class CustomBarColorsRenderer
    extends BarRenderer {
        private final Paint[] colors;

        public CustomBarColorsRenderer(Paint[] colors) {
            this.colors = colors;
        }

        public Paint getItemPaint(int row, int column) {
            return this.colors[column % this.colors.length];
        }
    }
}

