/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.customfields;

import com.atlassian.jconnect.jira.customfields.LocationIndexer;
import com.atlassian.jconnect.jira.customfields.LocationLikeQueryFactory;
import com.atlassian.jconnect.jira.customfields.LocationSearchClauseValidator;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SingleValueCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.ExactTextCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;

public class LocationSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final CustomFieldInputHelper customFieldInputHelper;
    private final JqlOperandResolver jqlOperandResolver;
    private final DoubleConverter doubleConverter;
    private final JiraAuthenticationContext authenticationContext;
    private volatile CustomFieldSearcherClauseHandler clauseHandler;
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;

    public LocationSearcher(FieldVisibilityManager fieldVisibilityManager, CustomFieldInputHelper customFieldInputHelper, JqlOperandResolver jqlOperandResolver, DoubleConverter doubleConverter, JiraAuthenticationContext authenticationContext) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.customFieldInputHelper = customFieldInputHelper;
        this.jqlOperandResolver = jqlOperandResolver;
        this.doubleConverter = doubleConverter;
        this.authenticationContext = authenticationContext;
    }

    public void init(CustomField field) {
        LocationIndexer indexer = new LocationIndexer(this.fieldVisibilityManager, field, this.doubleConverter);
        ClauseNames names = field.getClauseNames();
        EnumSet<Operator> supportedOps = EnumSet.of(Operator.LIKE, Operator.IN);
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new CustomFieldRenderer(names, this.getDescriptor(), field, (CustomFieldValueProvider)new SingleValueCustomFieldValueProvider(), this.fieldVisibilityManager);
        this.searchInputTransformer = new ExactTextCustomFieldSearchInputTransformer(field, names, this.searcherInformation.getId(), this.customFieldInputHelper);
        this.clauseHandler = new SimpleCustomFieldSearcherClauseHandler((ClauseValidator)new LocationSearchClauseValidator(supportedOps, this.jqlOperandResolver, this.authenticationContext.getI18nHelper()), (ClauseQueryFactory)new LocationLikeQueryFactory(this.jqlOperandResolver, field.getId(), this.doubleConverter, this.authenticationContext), supportedOps, JiraDataTypes.TEXT);
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        return this.checkInitialized(this.clauseHandler, "customFieldSearcherClauseHandler");
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        return (SearcherInformation)this.checkInitialized(this.searcherInformation, "searcherInformation");
    }

    public SearchInputTransformer getSearchInputTransformer() {
        return this.checkInitialized(this.searchInputTransformer, "searchInputTransformer");
    }

    public SearchRenderer getSearchRenderer() {
        return this.checkInitialized(this.searchRenderer, "searchRenderer");
    }

    private <T> T checkInitialized(T instance, String name) {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)(name + " not initialized! .init() has not been called yet"));
        return instance;
    }
}

