/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.customfields;

import com.atlassian.jconnect.jira.customfields.GeoCalculator;
import com.atlassian.jconnect.jira.customfields.LocationQuery;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Map;

public final class LocationParser {
    private static final Map<String, String> DEFAULT_MESSAGES = ImmutableMap.builder().put((Object)"customfields.locationsearcher.error.nothreefields", (Object)"Raw value '{0}' should contain 3 fields separated by comma").put((Object)"customfields.location.lat", (Object)"Latitude").put((Object)"customfields.location.lng", (Object)"Longitude").put((Object)"customfields.locationsearcher.error.parselnglat", (Object)"Unable to parse value {0} of field {1}").put((Object)"customfields.locationsearcher.error.latlngnotinrange", (Object)"{0} value {1} is not in expected range {2}").put((Object)"customfields.locationsearcher.error.parsedistance", (Object)"Unable to parse distance value {0}").put((Object)"customfields.locationsearcher.error.distancenegative", (Object)"Distance value {0} must not be negative").build();

    private LocationParser() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static LocationQuery validateAndParseLocationQuery(String rawValue, I18nHelper i18n, MessageSet errors) {
        String[] split = rawValue.split(",");
        if (split.length != 3) {
            errors.addErrorMessage(LocationParser.i18nizeOrNot(i18n, "customfields.locationsearcher.error.nothreefields", rawValue));
            return null;
        }
        String latName = LocationParser.i18nizeOrNot(i18n, "customfields.location.lat", new Object[0]);
        double lat = LocationParser.checkLatLng(i18n, errors, split[0].trim(), latName);
        if (!GeoCalculator.LAT_RANGE.containsDouble(lat)) {
            LocationParser.i18nizeOrNot(i18n, "customfields.locationsearcher.error.latlngnotinrange", latName, lat, GeoCalculator.LAT_RANGE);
        }
        String lngName = LocationParser.i18nizeOrNot(i18n, "customfields.location.lng", new Object[0]);
        double lng = LocationParser.checkLatLng(i18n, errors, split[1].trim(), lngName);
        if (!GeoCalculator.LNG_RANGE.containsDouble(lng)) {
            LocationParser.i18nizeOrNot(i18n, "customfields.locationsearcher.error.latlngnotinrange", lngName, lng, GeoCalculator.LNG_RANGE);
        }
        long distance = LocationParser.checkDistance(i18n, errors, split[2].trim());
        if (errors.hasAnyErrors()) {
            return null;
        }
        return new LocationQuery(lat, lng, distance);
    }

    public static LocationQuery parseLocationQuery(String rawValue) {
        MessageSetImpl errors = new MessageSetImpl();
        LocationQuery result = LocationParser.validateAndParseLocationQuery(rawValue, null, (MessageSet)errors);
        if (errors.hasAnyErrors()) {
            throw new IllegalArgumentException("Unable to parse " + rawValue + ":\n" + errors.getErrorMessages());
        }
        return result;
    }

    private static double checkLatLng(I18nHelper i18n, MessageSet errors, String value, String name) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            errors.addErrorMessage(LocationParser.i18nizeOrNot(i18n, "customfields.locationsearcher.error.parselnglat", value, name));
            return -1.0;
        }
    }

    private static long checkDistance(I18nHelper i18n, MessageSet errors, String value) {
        try {
            long distance = Long.parseLong(value);
            if (distance < 0L) {
                errors.addErrorMessage(LocationParser.i18nizeOrNot(i18n, "customfields.locationsearcher.error.distancenegative", value));
                return -1L;
            }
            return distance;
        }
        catch (NumberFormatException nfe) {
            errors.addErrorMessage(LocationParser.i18nizeOrNot(i18n, "customfields.locationsearcher.error.parsedistance", value));
            return -1L;
        }
    }

    private static String i18nizeOrNot(I18nHelper i18n, String key, Object ... params) {
        if (i18n != null) {
            return i18n.getText(key, (Object)params);
        }
        String rawMsg = DEFAULT_MESSAGES.get(key);
        if (rawMsg == null) {
            return "*** NO MESSAGE FOR <" + key + ">";
        }
        return MessageFormat.format(rawMsg, params);
    }
}

