/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.customfields;

import com.atlassian.jconnect.jira.customfields.GeoCalculator;
import com.atlassian.jconnect.jira.customfields.LocationIndexer;
import com.atlassian.jconnect.jira.customfields.LocationParser;
import com.atlassian.jconnect.jira.customfields.LocationQuery;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.math.DoubleRange;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationLikeQueryFactory
implements ClauseQueryFactory {
    private static final Logger logger = LoggerFactory.getLogger(LocationLikeQueryFactory.class);
    private final JiraAuthenticationContext authenticationContext;
    private final JqlOperandResolver jqlOperandResolver;
    private final DoubleConverter doubleConverter;
    private final String latFieldId;
    private final String lngFieldId;

    public LocationLikeQueryFactory(JqlOperandResolver jqlOperandResolver, String fieldId, DoubleConverter doubleConverter, JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        this.jqlOperandResolver = jqlOperandResolver;
        this.doubleConverter = doubleConverter;
        this.latFieldId = LocationIndexer.latFieldId(fieldId);
        this.lngFieldId = LocationIndexer.lngFieldId(fieldId);
    }

    public QueryFactoryResult getQuery(@NotNull QueryCreationContext queryCreationContext, @NotNull TerminalClause terminalClause) {
        try {
            return this.getQueryUnsafe(queryCreationContext, terminalClause);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Could not parse the query: " + e.getMessage());
            return QueryFactoryResult.createFalseResult();
        }
    }

    private QueryFactoryResult getQueryUnsafe(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        if (terminalClause.getOperator() == Operator.LIKE) {
            LocationQuery query = LocationParser.parseLocationQuery(this.jqlOperandResolver.getSingleValue(queryCreationContext.getQueryUser(), terminalClause.getOperand(), terminalClause).getStringValue()).normalize();
            double minLat = this.getMinLat(query);
            double maxLat = this.getMaxLat(query);
            double minLng = this.getMinLng(query);
            double maxLng = this.getMaxLng(query);
            BooleanQuery answer = new BooleanQuery();
            this.addLatQuery(minLat, maxLat, answer);
            this.addLngQuery(minLng, maxLng, answer);
            return new QueryFactoryResult((Query)answer, false);
        }
        if (terminalClause.getOperator() == Operator.IN) {
            BooleanQuery answer = new BooleanQuery();
            List literals = this.jqlOperandResolver.getValues(queryCreationContext.getQueryUser(), terminalClause.getOperand(), terminalClause);
            for (QueryLiteral literal : literals) {
                JSONObject jsonObject = this.reverseGeo(literal.getStringValue());
                this.fillQuery(jsonObject, answer);
            }
            answer.setMinimumNumberShouldMatch(1);
            return new QueryFactoryResult((Query)answer, false);
        }
        throw new IllegalArgumentException("Unsupported operator in clause " + terminalClause);
    }

    private double getMaxLng(LocationQuery query) {
        double maxLng = query.lng + GeoCalculator.kmsToLongitude(query.lat, query.radius);
        if (!GeoCalculator.NORMALIZED_LNG_RANGE.containsDouble(maxLng)) {
            maxLng = GeoCalculator.NORMALIZED_LNG_RANGE.getMaximumDouble();
        }
        return maxLng;
    }

    private double getMinLng(LocationQuery query) {
        double minLng = query.lng - GeoCalculator.kmsToLongitude(query.lat, query.radius);
        if (!GeoCalculator.NORMALIZED_LNG_RANGE.containsDouble(minLng)) {
            minLng = GeoCalculator.NORMALIZED_LNG_RANGE.getMinimumDouble();
        }
        return minLng;
    }

    private double getMaxLat(LocationQuery query) {
        double maxLat = query.lat + GeoCalculator.kmsToLatitude(query.radius);
        if (!GeoCalculator.NORMALIZED_LAT_RANGE.containsDouble(maxLat)) {
            maxLat = GeoCalculator.NORMALIZED_LAT_RANGE.getMaximumDouble();
        }
        return maxLat;
    }

    private double getMinLat(LocationQuery query) {
        double minLat = query.lat - GeoCalculator.kmsToLatitude(query.radius);
        if (!GeoCalculator.NORMALIZED_LAT_RANGE.containsDouble(minLat)) {
            minLat = GeoCalculator.NORMALIZED_LAT_RANGE.getMinimumDouble();
        }
        return minLat;
    }

    private JSONObject reverseGeo(String address) {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod("http://maps.googleapis.com/maps/api/geocode/json");
        ArrayList query = Lists.newArrayList();
        query.add(new NameValuePair("sensor", "false"));
        query.add(new NameValuePair("address", address));
        query.add(new NameValuePair("region", this.getRegion()));
        method.setQueryString(query.toArray(new NameValuePair[query.size()]));
        logger.info("Executing method " + method);
        try {
            int response = client.executeMethod((HttpMethod)method);
            if (response == 200) {
                return new JSONObject(method.getResponseBodyAsString());
            }
        }
        catch (IOException e) {
            logger.error("Exception while executing request", (Throwable)e);
        }
        catch (JSONException e) {
            logger.error("Exception while parsing response", (Throwable)e);
        }
        return new JSONObject();
    }

    private void fillQuery(JSONObject response, BooleanQuery answer) {
        try {
            String status = (String)response.get("status");
            if (status.equals("OK")) {
                JSONArray results = response.getJSONArray("results");
                for (int i = 0; i < results.length(); ++i) {
                    JSONObject location = results.getJSONObject(i);
                    JSONObject geometry = location.getJSONObject("geometry");
                    if (geometry.has("bounds")) {
                        this.addSquareQuery(geometry.getJSONObject("bounds"), answer);
                        continue;
                    }
                    this.addSquareQuery(geometry.getJSONObject("viewport"), answer);
                }
            } else {
                logger.warn("Error response from GMaps: " + status);
            }
        }
        catch (JSONException e) {
            logger.error("Error parsing GMaps response", (Throwable)e);
        }
    }

    private void addSquareQuery(JSONObject bounds, BooleanQuery mainQuery) throws JSONException {
        JSONObject sw = bounds.getJSONObject("southwest");
        double lat1 = (Double)sw.get("lat");
        double lng1 = (Double)sw.get("lng");
        JSONObject ne = bounds.getJSONObject("northeast");
        double lat2 = (Double)ne.get("lat");
        double lng2 = (Double)ne.get("lng");
        double minLat = GeoCalculator.normalizeLat(Math.min(lat1, lat2));
        double maxLat = GeoCalculator.normalizeLat(Math.max(lat1, lat2));
        double minLng = GeoCalculator.normalizeLng(Math.min(lng1, lng2));
        double maxLng = GeoCalculator.normalizeLng(Math.max(lng1, lng2));
        BooleanQuery subQuery = new BooleanQuery();
        this.addLatQuery(minLat, maxLat, subQuery);
        this.addLngQuery(minLng, maxLng, subQuery);
        mainQuery.add((Query)subQuery, BooleanClause.Occur.SHOULD);
    }

    private String getRegion() {
        Locale locale = this.authenticationContext.getLocale();
        String region = locale.getCountry();
        return !region.equals("gb") ? region : "uk";
    }

    private void addLatQuery(double minLat, double maxLat, BooleanQuery answer) {
        if (!this.fullRange(minLat, maxLat, GeoCalculator.NORMALIZED_LAT_RANGE)) {
            answer.add((Query)new TermRangeQuery(this.latFieldId, this.encode(minLat), this.encode(maxLat), true, true), BooleanClause.Occur.MUST);
        }
    }

    private void addLngQuery(double minLng, double maxLng, BooleanQuery answer) {
        if (!this.fullRange(minLng, maxLng, GeoCalculator.NORMALIZED_LNG_RANGE)) {
            answer.add((Query)new TermRangeQuery(this.lngFieldId, this.encode(minLng), this.encode(maxLng), true, true), BooleanClause.Occur.MUST);
        }
    }

    private boolean fullRange(double min, double max, DoubleRange rangeToCompare) {
        return rangeToCompare.getMinimumDouble() == min && rangeToCompare.getMaximumDouble() == max;
    }

    private String encode(double val) {
        return this.doubleConverter.getStringForLucene(Double.valueOf(val));
    }
}

