/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.customfields;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang.math.DoubleRange;

public final class GeoCalculator {
    public static final DoubleRange LAT_RANGE = new DoubleRange(-90.0, 90.0);
    public static final DoubleRange LNG_RANGE = new DoubleRange(-180.0, 180.0);
    public static final double LAT_NORMALIZE_FACTOR = 90.0;
    public static final double LNG_NORMALIZE_FACTOR = 180.0;
    public static final DoubleRange NORMALIZED_LAT_RANGE = GeoCalculator.move(LAT_RANGE, 90.0);
    public static final DoubleRange NORMALIZED_LNG_RANGE = GeoCalculator.move(LNG_RANGE, 180.0);
    private static final double KMS_IN_LAT_DEGREE = 111.0;
    private static Map<DoubleRange, Double> KMS_IN_LNG_DEGREE = ImmutableMap.builder().put((Object)GeoCalculator.newRange(0L, 10L), (Object)110.9).put((Object)GeoCalculator.newRange(10L, 20L), (Object)107.55).put((Object)GeoCalculator.newRange(20L, 30L), (Object)100.95).put((Object)GeoCalculator.newRange(30L, 40L), (Object)91.288).put((Object)GeoCalculator.newRange(40L, 50L), (Object)78.847).put((Object)GeoCalculator.newRange(50L, 60L), (Object)63.994).put((Object)GeoCalculator.newRange(60L, 70L), (Object)47.176).put((Object)GeoCalculator.newRange(70L, 80L), (Object)28.902).put((Object)GeoCalculator.newRange(80L, 90L), (Object)9.735).build();

    private static DoubleRange move(DoubleRange source, double factor) {
        return new DoubleRange(source.getMinimumDouble() + factor, source.getMaximumDouble() + factor);
    }

    private static DoubleRange newRange(long lower, long upper) {
        return new DoubleRange(lower, upper);
    }

    private GeoCalculator() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static double kmsToLngRatio(double atLatitude) {
        double absLatitude = Math.abs(atLatitude);
        Preconditions.checkArgument((absLatitude >= 0.0 && absLatitude <= 90.0 ? 1 : 0) != 0, (Object)("Latitude <" + atLatitude + "> must be in range 0-90"));
        for (Map.Entry<DoubleRange, Double> ratios : KMS_IN_LNG_DEGREE.entrySet()) {
            if (!ratios.getKey().containsDouble(absLatitude)) continue;
            return ratios.getValue();
        }
        throw new AssertionError((Object)"dkordonski can't code right!");
    }

    public static double kmsToLongitude(double atLatitude, long kms) {
        double ratio = GeoCalculator.kmsToLngRatio(atLatitude);
        return (double)kms / ratio;
    }

    public static double kmsToLatitude(long kms) {
        return (double)kms / 111.0;
    }

    public static double normalizeLat(double lat) {
        return lat + 90.0;
    }

    public static double normalizeLng(double lng) {
        return lng + 180.0;
    }
}

