/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.customfields;

import com.atlassian.jconnect.jira.customfields.BuiltInField;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldHelper {
    private static final Logger logger = LoggerFactory.getLogger(CustomFieldHelper.class);
    private final CustomFieldManager customFieldManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public CustomFieldHelper(CustomFieldManager customFieldManager, IssueTypeSchemeManager issueTypeSchemeManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.customFieldManager = customFieldManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    static List<String> issueTypeIdsFor(Project project, IssueTypeSchemeManager issueTypeSchemeManager) {
        return Lists.transform((List)ImmutableList.copyOf((Collection)issueTypeSchemeManager.getIssueTypesForProject(project)), (Function)new Function<IssueType, String>(){

            public String apply(@Nullable IssueType from) {
                return from.getId();
            }
        });
    }

    public boolean containsField(Project project, CustomField field) {
        if (field == null) {
            return false;
        }
        return field.isInScope(project, this.issueTypeIdsFor(project));
    }

    private List<String> issueTypeIdsFor(Project project) {
        return CustomFieldHelper.issueTypeIdsFor(project, this.issueTypeSchemeManager);
    }

    public boolean containsAllFields(Project project, CustomField ... fields) {
        boolean result = true;
        for (CustomField field : fields) {
            result &= this.containsField(project, field);
        }
        return result;
    }

    public CustomField[] getAllBuiltInCustomFields() {
        return this.initBuiltInCustomFields(BuiltInField.values());
    }

    public CustomField[] initBuiltInCustomFields(BuiltInField ... fields) {
        ArrayList collector = Lists.newArrayList();
        for (BuiltInField field : fields) {
            collector.add(this.initBuiltInCustomField(field));
        }
        return collector.toArray(new CustomField[collector.size()]);
    }

    public CustomField initBuiltInCustomField(BuiltInField field) {
        return this.initBuiltInCustomField(field, true);
    }

    private CustomField initBuiltInCustomField(BuiltInField fieldDescription, boolean createIfNecessary) {
        Collection fields = this.customFieldManager.getCustomFieldObjectsByName(fieldDescription.fieldName());
        if (fields != null) {
            for (CustomField field : fields) {
                if (!field.getCustomFieldType().getKey().equals(fieldDescription.fieldTypeKey())) continue;
                return field;
            }
        }
        if (createIfNecessary) {
            return this.createBuiltInCustomField(fieldDescription);
        }
        logger.warn("Field not yet created: " + fieldDescription.fullDescription());
        return null;
    }

    private CustomField createBuiltInCustomField(BuiltInField field) {
        try {
            return this.customFieldManager.createCustomField(field.fieldName(), this.getText("customfields.builtin.description", new Object[0]), this.customFieldManager.getCustomFieldType(field.fieldTypeKey()), this.customFieldManager.getCustomFieldSearcher(field.searcherKey()), null, null);
        }
        catch (GenericEntityException e) {
            logger.warn("Unable to create field " + field.fullDescription(), (Throwable)e);
            return null;
        }
    }

    private String getText(String key, Object ... params) {
        if (params.length > 0) {
            return this.jiraAuthenticationContext.getI18nHelper().getText(key, (Object)params);
        }
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }
}

