/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.admin;

import com.atlassian.jconnect.jira.JMCProjectService;
import com.atlassian.jconnect.rest.entities.ProjectStatusEntity;
import com.atlassian.jira.plugin.projectoperation.AbstractPluggableProjectOperation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.HashMap;

public class JMCProjectSettings
extends AbstractPluggableProjectOperation {
    private final JMCProjectService projectService;

    public JMCProjectSettings(JMCProjectService projectService) {
        this.projectService = projectService;
    }

    public String getHtml(Project project, ApplicationUser user) {
        HashMap<String, ProjectStatusEntity> startingParams = new HashMap<String, ProjectStatusEntity>();
        boolean enabled = this.projectService.isJiraConnectProject(project);
        String apiKey = enabled ? this.projectService.lookupApiKeyFor(project) : "";
        boolean apiKeyActive = this.projectService.isApiKeyEnabledFor(project);
        boolean crashesEnabled = this.projectService.isCrashesEnabledFor(project);
        startingParams.put("projectStatus", new ProjectStatusEntity(project.getId(), project.getKey(), enabled, apiKey, false, apiKeyActive, crashesEnabled));
        String html = this.descriptor.getHtml("view", startingParams);
        return html;
    }

    public boolean showOperation(Project project, ApplicationUser user) {
        return true;
    }
}

