/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira;

import com.atlassian.core.util.FileUtils;
import com.atlassian.jconnect.rest.entities.IssueEntity;
import com.atlassian.jconnect.rest.entities.UploadData;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.UpdateException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.project.DefaultAssigneeException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.util.AttachmentException;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueHelper {
    private static final Logger log = LoggerFactory.getLogger(IssueHelper.class);
    private static final Map<String, String> SUPPORTED_ATTACHMENT_TYPE_SUFFIXES;
    public static final String ENVIRONMENT_FORMAT = "Model: %s\nOS Version: %s\nApp Version: %s\nLanguage: %s\n";
    public static final Pattern ENV_FIELD_PATTERN;
    private final IssueManager issueManager;
    private final AttachmentManager attachmentManager;
    private final ProjectManager projectManager;
    private final VersionManager versionManager;
    private final ConstantsManager constantsManager;
    private final IssueFactory issueFactory;
    private final CommentService commentService;
    private final ProjectComponentManager componentManager;

    private static String getContentTypeFileSuffix(String contentType) {
        return SUPPORTED_ATTACHMENT_TYPE_SUFFIXES.get(contentType);
    }

    public IssueHelper(IssueManager issueManager, AttachmentManager attachmentManager, ProjectManager projectManager, VersionManager versionManager, ConstantsManager constantsManager, IssueFactory issueFactory, CommentService commentService, ProjectComponentManager componentManager) {
        this.issueManager = issueManager;
        this.attachmentManager = attachmentManager;
        this.projectManager = projectManager;
        this.versionManager = versionManager;
        this.constantsManager = constantsManager;
        this.issueFactory = issueFactory;
        this.commentService = commentService;
        this.componentManager = componentManager;
    }

    public MutableIssue getIssue(String issueKey) {
        return this.issueManager.getIssueObject(issueKey);
    }

    public Issue createIssue(IssueEntity issueEntity, CustomField uuid, Project project, ApplicationUser user, List<CustomField> customFields, List<Object> customValues) throws AttachmentException, IOException, GenericEntityException, CreateException {
        IssueType issueType = this.resolveIssueType(issueEntity);
        MutableIssue issue = this.issueFactory.getIssue();
        HashMap<String, Version> allVersions = new HashMap<String, Version>();
        Version appVersion = this.getVersionNamed(project.getId(), issueEntity.getAppVersion());
        Version appShortVersion = this.getVersionNamed(project.getId(), issueEntity.getAppVersionShort());
        this.addIfNonNull(allVersions, appVersion);
        this.addIfNonNull(allVersions, appShortVersion);
        issue.setProjectId(project.getId());
        issue.setIssueTypeId(issueType.getId());
        issue.setAffectedVersions(allVersions.values());
        Collection<ProjectComponent> components = this.setProjectComponents(issueEntity, project, issue);
        String appVersionName = issueEntity.getAppVersionShort() != null ? issueEntity.getAppVersionShort() : issueEntity.getAppVersion();
        String env = String.format(ENVIRONMENT_FORMAT, issueEntity.getModel(), issueEntity.getSystemVersion(), appVersionName, issueEntity.getLanguage());
        issue.setEnvironment(env);
        issue.setSummary(issueEntity.getSummary());
        issue.setDescription(issueEntity.getDescription());
        issue.setReporter(user);
        this.setDefaultAssignee(project, issue, components);
        HashSet<Label> labels = new HashSet<Label>(3);
        this.addLabel(labels, "", issueEntity.getSystemVersion());
        this.addLabel(labels, "", issueEntity.getModel());
        this.addLabel(labels, "", issueEntity.getLanguage());
        this.addLabel(labels, "build-", issueEntity.getAppVersion());
        issue.setLabels(labels);
        for (int i = 0; i < customFields.size(); ++i) {
            CustomField field = customFields.get(i);
            Object value = customValues.get(i);
            log.debug("Setting customfield: " + field.getName() + " = " + value);
            if (field.getRelevantConfig((Issue)issue) != null) {
                issue.setCustomFieldValue(field, value);
                continue;
            }
            log.debug("Field " + field.getName() + " is missing a configuration context for project: " + project.getName() + ". This field wont be added to the issue.");
        }
        if (uuid != null && uuid.getRelevantConfig((Issue)issue) != null) {
            issue.setCustomFieldValue(uuid, (Object)issueEntity.getUuid());
        } else {
            String missingUUIDMessage = "\n*NB " + project.getName() + " is missing the custom field called uuid. " + "JIRAConnect uses this to map mobile users to issues. Without this field, " + "users will not receive any In-App issue comments.*";
            issue.setEnvironment(issue.getEnvironment() + "\n" + missingUUIDMessage);
            log.warn(missingUUIDMessage);
        }
        this.issueManager.createIssueObject(user, (Issue)issue);
        log.debug("User {} created issue {}: {}", new Object[]{user.getKey(), issue.getKey(), issue.getSummary()});
        return issue;
    }

    private void setDefaultAssignee(Project project, MutableIssue issue, Collection<ProjectComponent> components) {
        try {
            ApplicationUser defaultAssignee = this.projectManager.getDefaultAssignee(project, components);
            if (defaultAssignee != null) {
                issue.setAssignee(defaultAssignee);
            }
        }
        catch (DefaultAssigneeException e) {
            log.info("Not setting default assignee on issue: " + issue.getKey() + " due to: " + e.getLocalizedMessage());
        }
    }

    private void addIfNonNull(Map<String, Version> allVersions, Version appVersion) {
        if (appVersion != null) {
            allVersions.put(appVersion.getName(), appVersion);
        }
    }

    private Version getVersionNamed(Long projectId, String name) {
        if (name == null) {
            return null;
        }
        List versions = this.versionManager.getVersions(projectId);
        for (Version next : versions) {
            if (!name.equals(next.getName())) continue;
            return next;
        }
        return null;
    }

    private void addLabel(Set<Label> labels, String prefix, String value) {
        if (value != null) {
            String label = value.replaceAll("\\s", "-");
            labels.add(new Label(null, null, prefix + label));
        }
    }

    private Collection<ProjectComponent> setProjectComponents(IssueEntity issueEntity, Project project, MutableIssue issue) {
        ArrayList<ProjectComponent> projectComponents = new ArrayList<ProjectComponent>();
        if (issueEntity.getComponents() != null) {
            String[] comps = issueEntity.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                String compName = comps[i];
                ProjectComponent component = this.componentManager.findByComponentName(project.getId(), compName);
                if (component == null) continue;
                projectComponents.add(component);
            }
            issue.setComponent(projectComponents);
        }
        return projectComponents;
    }

    private IssueType resolveIssueType(IssueEntity issueEntity) {
        Collection types = this.constantsManager.getAllIssueTypeObjects();
        for (IssueType next : types) {
            if (!next.getName().equalsIgnoreCase(issueEntity.getType())) continue;
            return next;
        }
        return (IssueType)types.iterator().next();
    }

    public void addAttachment(Issue issue, UploadData data, ApplicationUser user) throws IOException, AttachmentException, GenericEntityException {
        File attachmentFile = File.createTempFile("jconnect-" + issue.getKey() + "-", IssueHelper.getContentTypeFileSuffix(data.getContentType()));
        FileUtils.copyFile((InputStream)data.getInputStream(), (File)attachmentFile, (boolean)true);
        this.attachmentManager.createAttachment(attachmentFile, data.getFilename(), data.getContentType(), user, issue);
        log.debug("User {} attached {} to {}", new Object[]{user.getKey(), data.getFilename(), issue.getKey()});
    }

    public ErrorCollection updateIssue(MutableIssue issue, IssueEntity issueEntity, ApplicationUser user) throws UpdateException {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Long projectId = issue.getProjectObject().getId();
        HashMap<String, Version> uniqueVersions = new HashMap<String, Version>();
        this.addIfNonNull(uniqueVersions, this.getVersionNamed(projectId, issueEntity.getAppVersion()));
        this.addIfNonNull(uniqueVersions, this.getVersionNamed(projectId, issueEntity.getAppVersionShort()));
        Collection affectedVersions = issue.getAffectedVersions();
        Iterator iterator = affectedVersions.iterator();
        while (iterator.hasNext()) {
            this.addIfNonNull(uniqueVersions, (Version)iterator.next());
        }
        issue.setAffectedVersions(uniqueVersions.values());
        this.issueManager.updateIssue(user, issue, EventDispatchOption.ISSUE_UPDATED, true);
        return errors;
    }

    public ErrorCollection addComment(Issue issue, String bodyText, ApplicationUser user) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        this.commentService.create(user, issue, bodyText, true, (ErrorCollection)errors);
        log.debug("Comment was: " + bodyText);
        return errors;
    }

    public Project lookupProjectByName(String projectName) {
        return this.projectManager.getProjectObjByName(projectName);
    }

    public Project lookupProjectByKey(String projectKey) {
        return this.projectManager.getProjectObjByKey(projectKey);
    }

    static {
        ENV_FIELD_PATTERN = Pattern.compile("Model: (.*)[\r\n]*OS Version: (.*)[\r\n]*App Version: (.*)[\r\n]*", 8);
        HashMap<String, String> typeSuffixes = new HashMap<String, String>();
        typeSuffixes.put("image/gif", ".gif");
        typeSuffixes.put("image/jpeg", ".jpg");
        typeSuffixes.put("image/png", ".png");
        typeSuffixes.put("audio/x-caf", ".caf");
        typeSuffixes.put("audio/mpeg", ".mp3");
        typeSuffixes.put("audio/x-wav", ".wav");
        SUPPORTED_ATTACHMENT_TYPE_SUFFIXES = ImmutableMap.copyOf(typeSuffixes);
    }
}

