/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.integration.jira.element.JiraIssuesDialog;
import com.atlassian.webdriver.integration.jira.element.JiraTransitionForm;
import com.google.common.base.Function;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.openqa.selenium.By;

public class JiraIssuePanel {
    private static final String ATTR_LAST_UPDATED = "data-last-updated";
    @Inject
    private PageBinder pageBinder;
    @Inject
    private Timeouts timeouts;
    private final PageElement container;
    private final JiraIssuesDialog parent;

    public JiraIssuePanel(PageElement container, JiraIssuesDialog parent) {
        this.container = container;
        this.parent = parent;
    }

    public String getAssignee() {
        return this.getComplexFieldText("assignee");
    }

    public String getIssueKey() {
        return this.getFieldText("key");
    }

    public String getDescription() {
        return this.getFieldText("description");
    }

    public String getIssueType() {
        return this.getComplexFieldText("type");
    }

    public String getPriority() {
        return this.getComplexFieldText("priority");
    }

    public String getStatus() {
        PageElement statusField = this.getField("status");
        PageElement statusLozenge = statusField.find(By.className((String)"jira-issue-status-lozenge"));
        PageElement statusIcon = statusField.find(By.tagName((String)"img"));
        return statusLozenge.isPresent() ? statusLozenge.getText() : (statusIcon.isPresent() ? statusIcon.getAttribute("alt").toUpperCase() : null);
    }

    public String getSummary() {
        return this.getFieldText("summary");
    }

    public JiraIssuePanel transitionIssue(String transitionName) {
        return this.executeTransition(transitionName, new Function<PageElement, JiraIssuePanel>(){

            public JiraIssuePanel apply(final PageElement transition) {
                JiraIssuePanel.this.waitUntilUpdated(JiraIssuePanel.this.container, new Runnable(){

                    @Override
                    public void run() {
                        transition.click();
                    }
                });
                return JiraIssuePanel.this.parent.getIssuePanel();
            }
        });
    }

    public JiraTransitionForm transitionIssueExpectingForm(String transitionName) {
        return this.executeTransition(transitionName, new Function<PageElement, JiraTransitionForm>(){

            public JiraTransitionForm apply(PageElement transition) {
                transition.click();
                JiraTransitionForm form = JiraIssuePanel.this.parent.getTransitionForm();
                Poller.waitUntilTrue((TimedQuery)form.isShowing());
                return form;
            }
        });
    }

    private <T> T executeTransition(String transitionName, Function<PageElement, T> execute) {
        List transitions = this.container.findAll(By.className((String)"jira-transition"));
        for (PageElement transition : transitions) {
            if (!transitionName.equals(transition.getText())) continue;
            return (T)execute.apply((Object)transition);
        }
        throw new IllegalArgumentException("Transition with name " + transitionName + " not found.");
    }

    private String getFieldText(String name) {
        return this.getField(name).getText();
    }

    private String getComplexFieldText(String name) {
        return this.getComplexField(name).getText();
    }

    private PageElement getField(String name) {
        return this.container.find(By.cssSelector((String)(".issue-" + name)));
    }

    private PageElement getComplexField(String name) {
        return this.container.find(By.cssSelector((String)(".issue-" + name + " .field-text")));
    }

    public TimedCondition isShowing(String issueKey) {
        return this.getField("key").timed().hasText(issueKey);
    }

    private void waitUntilUpdated(PageElement element, Runnable operation) {
        Long lastUpdated = this.getLastUpdated(element);
        operation.run();
        this.waitUntilUpdated(element, lastUpdated);
    }

    private Long getLastUpdated(PageElement element) {
        return this.stringToLong(element.getAttribute(ATTR_LAST_UPDATED), null);
    }

    private void waitUntilUpdated(PageElement element, Long lastUpdated) {
        final long updated = lastUpdated == null ? -1L : lastUpdated;
        Poller.waitUntil((TimedQuery)element.timed().getAttribute(ATTR_LAST_UPDATED), (Matcher)new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String value) {
                return JiraIssuePanel.this.stringToLong(value, -1L) > updated;
            }

            public void describeTo(Description description) {
                description.appendText("more recent than").appendValue((Object)updated);
            }
        });
    }

    private Long stringToLong(String s, Long defaultValue) {
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

