/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.query.webdriver.GenericWebDriverTimedQuery;
import com.atlassian.webdriver.integration.jira.element.JiraTransitionField;
import java.util.List;
import org.openqa.selenium.By;

public class JiraAutoCompleteField
implements JiraTransitionField {
    protected final PageElement selectField;
    protected By hiddenSelector;
    protected final PageElement pageRoot;
    private final PageElement container;

    public JiraAutoCompleteField(PageElement container, By hiddenSelector, PageElement pageRoot) {
        this.container = container;
        this.selectField = container.find(By.cssSelector((String)".select2-container > a"));
        this.hiddenSelector = hiddenSelector;
        this.pageRoot = pageRoot;
    }

    @Override
    public String getValue() {
        return this.selectField.getValue();
    }

    @Override
    public void setValue(String val) {
        PageElement popup = this.performSearch(val);
        PageElement selectedItem = popup.find(By.cssSelector((String)".select2-highlighted"));
        selectedItem.click();
    }

    public void chooseValue(String val) {
        this.selectField.click();
        PageElement select2Dropdown = this.pageRoot.find(By.id((String)"select2-drop"));
        Poller.waitUntilTrue((TimedQuery)select2Dropdown.timed().isVisible());
        List options = select2Dropdown.findAll(By.cssSelector((String)".select2-results > li"));
        for (PageElement option : options) {
            if (!option.getText().equals(val)) continue;
            option.click();
            break;
        }
    }

    public JiraAutoCompleteField waitUntilOptionsAvailable() {
        this.scrollIntoView();
        Poller.waitUntilTrue((TimedQuery)new GenericWebDriverTimedQuery(() -> {
            List options = this.container.findAll(By.cssSelector((String)"select > option"));
            int size = options.size();
            if (size > 1) {
                return true;
            }
            if (size == 1) {
                String placeholder = this.container.find(By.cssSelector((String)"select")).getAttribute("data-placeholder");
                if (placeholder == null) {
                    return true;
                }
                String optionText = ((PageElement)options.get(0)).getText();
                if (!placeholder.equals(optionText)) {
                    return true;
                }
            }
            throw new GenericWebDriverTimedQuery.InvalidValue((Object)false);
        }, 5000L));
        return this;
    }

    protected PageElement performSearch(String val) {
        this.scrollIntoView();
        Poller.waitUntilTrue((TimedQuery)this.selectField.timed().isVisible());
        this.selectField.click();
        PageElement popup = this.pageRoot.find(this.hiddenSelector);
        Poller.waitUntilTrue((TimedQuery)popup.timed().isVisible());
        PageElement selectInput = popup.find(By.cssSelector((String)"input"));
        selectInput.type(new CharSequence[]{val});
        Poller.waitUntilFalse((TimedQuery)selectInput.timed().hasClass("select2-active"));
        return popup;
    }

    protected void scrollIntoView() {
        this.selectField.javascript().execute("arguments[0].scrollIntoView();", new Object[0]);
    }
}

