/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.integration.jira.element.JiraTransitionField;
import java.util.List;
import org.openqa.selenium.By;

public class JiraTransitionAutoCompleteField
implements JiraTransitionField {
    private final PageElement selectField;
    private By hiddenSelector;
    private final PageElement pageRoot;

    public JiraTransitionAutoCompleteField(PageElement selectField, By hiddenSelector, PageElement pageRoot) {
        this.selectField = selectField;
        this.hiddenSelector = hiddenSelector;
        this.pageRoot = pageRoot;
    }

    @Override
    public String getValue() {
        return this.selectField.getValue();
    }

    @Override
    public void setValue(String val) {
        this.selectField.javascript().execute("arguments[0].scrollIntoView();", new Object[0]);
        this.selectField.click();
        PageElement popup = this.pageRoot.find(this.hiddenSelector);
        PageElement selectInput = popup.find(By.cssSelector((String)"input"));
        selectInput.type(new CharSequence[]{val});
        Poller.waitUntilFalse((TimedQuery)selectInput.timed().hasClass("select2-active"));
        PageElement selectedItem = popup.find(By.cssSelector((String)".select2-highlighted"));
        selectedItem.click();
    }

    public void chooseValue(String val) {
        this.selectField.click();
        PageElement select2Dropdown = this.pageRoot.find(By.id((String)"select2-drop"));
        Poller.waitUntilTrue((TimedQuery)select2Dropdown.timed().isVisible());
        List options = select2Dropdown.findAll(By.cssSelector((String)".select2-results > li"));
        for (PageElement option : options) {
            if (!option.getText().equals(val)) continue;
            option.click();
            break;
        }
    }
}

