/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element.internal;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.integration.jira.element.internal.WebLoginPage;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.WebDriver;

public class OAuthConfirmPage<T> {
    private final T nextPage;
    @Inject
    private WebDriver webDriver;
    @Inject
    private PageElementFinder elementFinder;
    @Inject
    private PageBinder pageBinder;
    @ElementBy(name="approve")
    private PageElement allowField;

    public OAuthConfirmPage(T nextPage) {
        this.nextPage = nextPage;
    }

    public T confirmHandlingWebLoginIfRequired(String originalWindowHandle, String username, String password) {
        return this.handleWebLoginIfRequiredThenClick(originalWindowHandle, username, password, this.allowField);
    }

    private T handleWebLoginIfRequiredThenClick(@Nonnull String originalWindowHandle, @Nonnull String username, @Nonnull String password, @Nonnull PageElement fieldToClick) {
        String targetWindowHandle = (String)Iterables.filter((Iterable)this.webDriver.getWindowHandles(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)originalWindowHandle))).iterator().next();
        this.webDriver.switchTo().window(targetWindowHandle);
        WebLoginPage maybeLoginPage = (WebLoginPage)this.pageBinder.bind(WebLoginPage.class, new Object[0]);
        Poller.waitUntilTrue((TimedQuery)Conditions.or((TimedQuery[])new TimedQuery[]{fieldToClick.timed().isPresent(), maybeLoginPage.isShowing()}));
        maybeLoginPage.handleWebLoginIfRequired(username, password);
        fieldToClick.click();
        this.webDriver.switchTo().window(originalWindowHandle);
        return this.nextPage;
    }
}

