/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class JiraIssueList {
    private final PageElement container;
    @Inject
    private Timeouts timeouts;

    public JiraIssueList(PageElement container) {
        this.container = container;
    }

    public TimedCondition isJiraIssueListVisible() {
        return this.container.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible();
    }

    public TimedQuery<List<String>> getJiraIssueKeys() {
        if (!((Boolean)this.container.timed().isVisible().byDefaultTimeout()).booleanValue()) {
            return Queries.forSupplier((Timeouts)this.timeouts, Collections::emptyList);
        }
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.container.findAll(By.className((String)"issue-item")).stream().map(e -> e.find(By.tagName((String)"a")).getAttribute("data-issuekey")).collect(Collectors.toList()), (TimeoutType)TimeoutType.PAGE_LOAD);
    }
}

