/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.integration.jira.element.JiraAllowedValuesField;
import com.atlassian.webdriver.integration.jira.element.JiraAssigneeField;
import com.atlassian.webdriver.integration.jira.element.JiraAutoCompleteField;
import com.atlassian.webdriver.integration.jira.element.JiraCheckboxesField;
import com.atlassian.webdriver.integration.jira.element.JiraRadioButtonsField;
import com.atlassian.webdriver.integration.jira.element.JiraTextField;
import com.atlassian.webdriver.integration.jira.element.JiraTextareaField;
import com.google.inject.Inject;
import org.openqa.selenium.By;

public class JiraForm {
    protected final PageElement container;
    @Inject
    protected PageElementFinder elementFinder;
    protected PageElement pageRoot;
    @Inject
    private PageBinder pageBinder;

    public JiraForm(PageElement container) {
        this.container = container;
    }

    public void clickSelectPageElement(String fieldId) {
        String id = "s2id_" + fieldId;
        this.elementFinder.find(By.id((String)id)).withTimeout(TimeoutType.SLOW_PAGE_LOAD).click();
        this.getAllowedValuesField(fieldId).waitUntilOptionsAvailable();
    }

    public void clearSelectPageElement(String fieldId) {
        String id = "s2id_" + fieldId;
        this.elementFinder.find(By.id((String)id)).find(By.className((String)"select2-search-choice-close")).withTimeout(TimeoutType.DIALOG_LOAD).click();
    }

    public JiraTextField getTextField(String name) {
        return this.getField(JiraTextField.class, By.cssSelector((String)("input[type=\"text\"][name=\"" + name + "\"]")));
    }

    public JiraTextareaField getTextareaField(String name) {
        return this.getField(JiraTextareaField.class, By.cssSelector((String)("textarea[name=\"" + name + "\"]")));
    }

    public JiraAllowedValuesField getAllowedValuesField(String name) {
        return this.getField(JiraAllowedValuesField.class, By.cssSelector((String)("select[name=\"" + name + "\"]")));
    }

    public JiraAutoCompleteField getAutoCompleteField(String name) {
        return this.getSelect2Field(JiraAutoCompleteField.class, By.cssSelector((String)("div[data-jira-type=\"" + name + "\"]")), By.id((String)"select2-drop"));
    }

    public JiraAssigneeField getAssigneeField(String name) {
        return this.getSelect2Field(JiraAssigneeField.class, By.cssSelector((String)("div[data-jira-type=\"" + name + "\"]")), By.id((String)"select2-drop"));
    }

    public JiraRadioButtonsField getRadioField(String type) {
        return this.getField(JiraRadioButtonsField.class, By.cssSelector((String)("fieldset[data-jira-type=\"" + type + "\"]")));
    }

    public JiraCheckboxesField getCheckboxesField(String type) {
        return this.getField(JiraCheckboxesField.class, By.cssSelector((String)("fieldset[data-jira-type=\"" + type + "\"]")));
    }

    public JiraTextField getLabelsField(String type) {
        return this.getField(JiraTextField.class, By.cssSelector((String)("div[data-jira-type=\"" + type + "\"] input.select2-input")));
    }

    public TimedCondition isShowing() {
        return this.container.timed().isVisible();
    }

    private <T> T getField(Class<T> type, By locator) {
        this.scrollTo(locator);
        return (T)this.pageBinder.bind(type, new Object[]{this.container.find(locator)});
    }

    private <T> T getSelect2Field(Class<T> type, By locator, By hiddenInputLocator) {
        this.scrollTo(locator);
        return (T)this.pageBinder.bind(type, new Object[]{this.container.find(locator), hiddenInputLocator, this.pageRoot});
    }

    private void scrollTo(By locator) {
        PageElement element = this.elementFinder.find(locator);
        this.scrollTo(element);
    }

    protected void scrollTo(PageElement element) {
        this.container.javascript().execute("AJS.$('[data-testid=client-plugins-modal],[data-testid=client-extensions-modal] header + div').scrollTop(" + element.getLocation().getY() + ")", new Object[0]);
    }

    @Init
    private void initRoot() {
        if (this.pageRoot == null) {
            this.pageRoot = this.elementFinder.find(By.tagName((String)"body"));
        }
    }
}

