/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.httpclient.apache.httpcomponents.DefaultMessage;
import com.atlassian.httpclient.api.EntityBuilder;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.base.AbstractHttpClient;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public class DefaultRequest
extends DefaultMessage
implements Request {
    private final AbstractHttpClient httpClient;
    private Request.Method method;
    private URI uri;
    private boolean cacheDisabled;
    private Map<String, String> attributes;

    public DefaultRequest(AbstractHttpClient httpClient) {
        this.httpClient = (AbstractHttpClient)Preconditions.checkNotNull((Object)httpClient);
        this.attributes = Maps.newHashMap();
        this.setAccept("*/*");
    }

    public DefaultRequest(AbstractHttpClient httpClient, URI uri) {
        this(httpClient, uri, null, null);
    }

    public DefaultRequest(AbstractHttpClient httpClient, URI uri, String contentType, String entity) {
        this(httpClient);
        this.setUri(uri).setContentType(contentType).setEntity(entity);
    }

    @Override
    public ResponsePromise get() {
        return this.execute(Request.Method.GET);
    }

    @Override
    public ResponsePromise post() {
        return this.execute(Request.Method.POST);
    }

    @Override
    public ResponsePromise put() {
        return this.execute(Request.Method.PUT);
    }

    @Override
    public ResponsePromise delete() {
        return this.execute(Request.Method.DELETE);
    }

    @Override
    public ResponsePromise options() {
        return this.execute(Request.Method.OPTIONS);
    }

    @Override
    public ResponsePromise head() {
        return this.execute(Request.Method.HEAD);
    }

    @Override
    public ResponsePromise trace() {
        return this.execute(Request.Method.TRACE);
    }

    @Override
    public ResponsePromise execute(Request.Method method) {
        Preconditions.checkNotNull((Object)((Object)method), (Object)"HTTP method must not be null");
        this.setMethod(method);
        return this.httpClient.execute(this);
    }

    @Override
    public Request.Method getMethod() {
        return this.method;
    }

    private Request setMethod(Request.Method method) {
        this.checkMutable();
        this.method = method;
        return this;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Request setUri(URI uri) {
        this.checkMutable();
        this.uri = uri;
        return this;
    }

    @Override
    public String getAccept() {
        return this.getHeader("Accept");
    }

    @Override
    public Request setAccept(String accept) {
        this.checkMutable();
        this.setHeader("Accept", accept);
        return this;
    }

    @Override
    public Request setCacheDisabled() {
        this.checkMutable();
        this.cacheDisabled = true;
        return this;
    }

    @Override
    public Request setAttribute(String name, String value) {
        this.checkMutable();
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public Request setAttributes(Map<String, String> properties) {
        this.checkMutable();
        this.attributes.putAll(properties);
        return this;
    }

    @Override
    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Request setEntity(EntityBuilder entityBuilder) {
        EntityBuilder.Entity entity = entityBuilder.build();
        return this.setHeaders((Map)entity.getHeaders()).setEntityStream(entity.getInputStream());
    }

    @Override
    public Request validate() {
        super.validate();
        Preconditions.checkNotNull((Object)this.uri);
        Preconditions.checkNotNull((Object)((Object)this.method));
        switch (this.method) {
            case GET: 
            case DELETE: 
            case HEAD: {
                if (!this.hasEntity()) break;
                throw new IllegalStateException("Request method " + (Object)((Object)this.method) + " does not support an entity");
            }
        }
        return this;
    }

    @Override
    public Request setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    @Override
    public Request setContentCharset(String contentCharset) {
        super.setContentCharset(contentCharset);
        return this;
    }

    @Override
    public Request setHeaders(Map<String, String> headers) {
        super.setHeaders(headers);
        return this;
    }

    @Override
    public Request setHeader(String name, String value) {
        super.setHeader(name, value);
        return this;
    }

    @Override
    public Request setEntity(String entity) {
        super.setEntity(entity);
        return this;
    }

    @Override
    public Request setEntityStream(InputStream entityStream, String encoding) {
        super.setEntityStream(entityStream, encoding);
        return this;
    }

    @Override
    public Request setEntityStream(InputStream entityStream) {
        super.setEntityStream(entityStream);
        return this;
    }

    public boolean isCacheDisabled() {
        return this.cacheDisabled;
    }

    @Override
    protected Request freeze() {
        super.freeze();
        return this;
    }
}

