/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.fugue.Option;
import com.atlassian.httpclient.apache.httpcomponents.DefaultResponse;
import com.atlassian.httpclient.apache.httpcomponents.HeadersBuilder;
import com.atlassian.httpclient.api.Entity;
import com.atlassian.httpclient.api.Headers;
import com.atlassian.httpclient.api.Response;

public class ResponseBuilder
implements Response.Builder {
    private Option<Entity> entity = Option.none();
    private final Headers.Builder headers = HeadersBuilder.builder();
    private int statusCode;
    private String statusText;

    static Response.Builder builder() {
        return new ResponseBuilder();
    }

    private ResponseBuilder() {
    }

    @Override
    public Response.Builder setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public Response.Builder setStatusText(String statusText) {
        this.statusText = statusText;
        return this;
    }

    @Override
    public Response.Builder setHeaders(Headers headers) {
        this.headers.addAll(headers);
        return this;
    }

    @Override
    public Response.Builder setEntity(Entity entity) {
        this.entity = Option.some(entity);
        return this;
    }

    @Override
    public Response build() {
        return new DefaultResponse(this.entity, (Headers)this.headers.build(), this.statusCode, this.statusText);
    }
}

