/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.fugue.Option;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHeaders;
import com.atlassian.httpclient.api.Entity;
import com.atlassian.httpclient.api.Headers;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.entity.mime.MultipartEntity;

public class MultipartEntityBuilder
implements Entity.Builder {
    private MultipartEntity apacheMultipartEntity;

    public static MultipartEntityBuilder builder() {
        return new MultipartEntityBuilder();
    }

    private MultipartEntityBuilder() {
    }

    public MultipartEntityBuilder entity(MultipartEntity entity) {
        this.apacheMultipartEntity = entity;
        return this;
    }

    @Override
    public Entity build() {
        final Supplier streamSupplier = Suppliers.memoize((Supplier)new Supplier<InputStream>(){

            public InputStream get() {
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    MultipartEntityBuilder.this.apacheMultipartEntity.writeTo(outputStream);
                    return new ByteArrayInputStream(outputStream.toByteArray());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        Header header = this.apacheMultipartEntity.getContentType();
        final HashMap headers = Maps.newHashMap();
        headers.put(header.getName(), header.getValue());
        return new Entity(){

            @Override
            public Headers headers() {
                return new DefaultHeaders(headers, Option.<Charset>none());
            }

            @Override
            public InputStream inputStream() {
                return (InputStream)streamSupplier.get();
            }
        };
    }
}

