/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.httpclient.apache.httpcomponents.HeadersBuilder;
import com.atlassian.httpclient.apache.httpcomponents.Util;
import com.atlassian.httpclient.api.Headers;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.Header;

class DefaultHeaders
implements Headers {
    private final Map<String, String> map;
    private final Option<Charset> charset;

    static Headers empty() {
        return new DefaultHeaders((Map<String, String>)ImmutableMap.of(), Option.<Charset>none());
    }

    static Headers from(Header ... headers) {
        return (Headers)HeadersBuilder.builder().addAll(Iterables.transform(Arrays.asList(headers), (Function)new Function<Header, Pair<String, String>>(){

            public Pair<String, String> apply(Header h) {
                return Pair.pair(h.getName(), h.getValue());
            }
        })).build();
    }

    DefaultHeaders(Map<String, String> map, Option<Charset> charset) {
        this.charset = charset;
        this.map = (Map)Preconditions.checkNotNull(map);
    }

    @Override
    public Iterator<Pair<String, String>> iterator() {
        return Util.pairIterator(this.map.entrySet());
    }

    @Override
    public Option<String> get(String name) {
        return Option.option(this.map.get(name));
    }

    @Override
    public String contentType() {
        return this.get("Content-Type").getOrElse("text/plain");
    }

    @Override
    public Option<Charset> contentCharset() {
        return this.charset;
    }

    @Override
    public Option<Integer> contentLength() {
        return this.get("Content-Length").flatMap(new Function<String, Option<Integer>>(){

            public Option<Integer> apply(String input) {
                return Option.some(Integer.parseInt(input));
            }
        });
    }
}

