/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.httpclient.apache.httpcomponents.EntityTooLargeException;
import com.google.common.primitives.Ints;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Asserts;

public class BoundedAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private static final int MAX_INITIAL_BUFFER_SIZE = 262144;
    private final int maxEntitySize;
    private volatile BoundedInputBuffer contentBuffer;
    private volatile DiscardBuffer discardBuffer;
    private volatile HttpResponse response;

    BoundedAsyncResponseConsumer(int maxEntitySize) {
        this.maxEntitySize = maxEntitySize;
    }

    protected HttpResponse buildResult(HttpContext context) {
        return this.response;
    }

    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull((Object)((Object)this.contentBuffer), (String)"Content buffer");
        if (this.contentBuffer.isDiscardMode()) {
            this.discardRemainingContent(decoder);
        } else {
            try {
                this.contentBuffer.consumeContent(decoder);
            }
            catch (BufferFullException e) {
                this.discardRemainingContent(decoder);
            }
        }
    }

    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        int length = Math.min(Ints.saturatedCast((long)entity.getContentLength()), this.maxEntitySize);
        if ((long)length < 0L) {
            length = Math.min(4096, this.maxEntitySize);
        }
        int initialBufferSize = Math.min(262144, length);
        this.contentBuffer = new BoundedInputBuffer(initialBufferSize, this.maxEntitySize, (ByteBufferAllocator)new HeapByteBufferAllocator());
        this.discardBuffer = new DiscardBuffer();
        Asserts.notNull((Object)this.response, (String)"response");
        this.response.setEntity((HttpEntity)new ContentBufferEntity(entity, (ContentInputBuffer)this.contentBuffer));
    }

    protected void onResponseReceived(HttpResponse response) throws IOException {
        this.response = response;
    }

    protected void releaseResources() {
        this.response = null;
        this.contentBuffer = null;
        this.discardBuffer = null;
    }

    private void discardRemainingContent(ContentDecoder decoder) throws IOException {
        this.contentBuffer.shutdown();
        this.discardBuffer.consumeContent(decoder);
        if (decoder.isCompleted()) {
            throw new EntityTooLargeException(this.response, "Entity content is too long; larger than " + this.maxEntitySize + " bytes");
        }
    }

    private static class BoundedInputBuffer
    extends SimpleInputBuffer {
        private final int maxSize;
        private boolean discardMode;

        BoundedInputBuffer(int initialSize, int maxSize, ByteBufferAllocator allocator) {
            super(Math.min(maxSize, initialSize), allocator);
            this.maxSize = maxSize;
        }

        public boolean isDiscardMode() {
            return this.discardMode;
        }

        protected void expand() {
            int newCapacity;
            int capacity = this.buffer.capacity();
            int n = newCapacity = capacity < 2 ? 2 : capacity + (capacity >>> 1);
            if (newCapacity < capacity) {
                newCapacity = Integer.MAX_VALUE;
            }
            this.ensureCapacity(newCapacity);
        }

        protected void ensureCapacity(int requiredCapacity) {
            if (this.buffer.capacity() == this.maxSize && requiredCapacity > this.maxSize) {
                this.discardMode = true;
                throw new BufferFullException();
            }
            super.ensureCapacity(Math.min(requiredCapacity, this.maxSize));
        }
    }

    private static class BufferFullException
    extends RuntimeException {
        private BufferFullException() {
        }
    }

    private static class DiscardBuffer
    extends SimpleInputBuffer {
        public DiscardBuffer() {
            super(4096);
        }

        protected void expand() {
            this.buffer.clear();
        }
    }
}

