/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.http.url;

import com.google.common.annotations.VisibleForTesting;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Locale;

public class SameOrigin {
    public static boolean isSameOrigin(URL url, URL origin) {
        if (url == null || origin == null) {
            return false;
        }
        String originHost = origin.getHost().toLowerCase(Locale.US);
        String urlHost = url.getHost().toLowerCase(Locale.US);
        return origin.getProtocol().equals(url.getProtocol()) && SameOrigin.getPortForUrl(origin) == SameOrigin.getPortForUrl(url) && originHost.equals(urlHost);
    }

    public static boolean isSameOrigin(URI uri, URI origin) throws MalformedURLException {
        if (uri == null || origin == null) {
            return false;
        }
        return SameOrigin.isSameOrigin(uri.toURL(), origin.toURL());
    }

    @VisibleForTesting
    static int getPortForUrl(URL url) {
        if (url.getPort() != -1) {
            return url.getPort();
        }
        return url.getDefaultPort();
    }
}

