/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.git.tripper;

import com.atlassian.git.tripper.Commit;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableCommit
implements Commit {
    private final String hash;
    private final Instant commitTime;

    private ImmutableCommit(String hash, Instant commitTime) {
        this.hash = hash;
        this.commitTime = commitTime;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public Instant getCommitTime() {
        return this.commitTime;
    }

    public final ImmutableCommit withHash(String value) {
        if (this.hash.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableCommit(newValue, this.commitTime);
    }

    public final ImmutableCommit withCommitTime(Instant value) {
        if (this.commitTime == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "commitTime");
        return new ImmutableCommit(this.hash, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommit && this.equalTo((ImmutableCommit)another);
    }

    private boolean equalTo(ImmutableCommit another) {
        return this.hash.equals(another.hash) && this.commitTime.equals(another.commitTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.commitTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Commit").omitNullValues().add("hash", (Object)this.hash).add("commitTime", (Object)this.commitTime).toString();
    }

    public static ImmutableCommit copyOf(Commit instance) {
        if (instance instanceof ImmutableCommit) {
            return (ImmutableCommit)instance;
        }
        return ImmutableCommit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_COMMIT_TIME = 2L;
        private long initBits = 3L;
        @Nullable
        private String hash;
        @Nullable
        private Instant commitTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Commit instance) {
            Objects.requireNonNull(instance, "instance");
            this.hash(instance.getHash());
            this.commitTime(instance.getCommitTime());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitTime(Instant commitTime) {
            this.commitTime = Objects.requireNonNull(commitTime, "commitTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCommit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommit(this.hash, this.commitTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commitTime");
            }
            return "Cannot build Commit, some of required attributes are not set " + attributes;
        }
    }
}

