/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.util;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.condition.UrlReadingCondition;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Map;

public class IsDevModeCondition
implements UrlReadingCondition {
    private static final String QUERY_PARAM = "devmode";
    private final LazyReference<Boolean> isDevMode = new LazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return Boolean.getBoolean("atlassian.dev.mode");
        }
    };

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (((Boolean)this.isDevMode.get()).booleanValue()) {
            urlBuilder.addToQueryString(QUERY_PARAM, "true");
        }
    }

    public boolean shouldDisplay(QueryParams params) {
        String devmode = params.get(QUERY_PARAM);
        return devmode != null && Boolean.parseBoolean(devmode);
    }
}

