/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.util;

import com.atlassian.gadgets.util.UrlBuilder;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.ApplicationProperties;

public abstract class AbstractUrlBuilder
implements UrlBuilder {
    private static final String PLUGINS_URI_COMPONENTS = "/plugins/servlet/gadgets";
    protected final WebResourceUrlProvider webResourceUrlProvider;
    protected final ApplicationProperties applicationProperties;
    private final String pluginModuleKey;

    public AbstractUrlBuilder(ApplicationProperties applicationProperties, WebResourceUrlProvider webResourceUrlProvider, String pluginModuleKey) {
        this.applicationProperties = applicationProperties;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.pluginModuleKey = pluginModuleKey;
    }

    @Override
    public String buildImageUrl(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.getBaseImageUrl() + path;
    }

    @Override
    public String buildRpcJsUrl() {
        return this.getBaseUrl() + "/js/rpc.js?c=1&debug=1";
    }

    protected String getBaseUrl() {
        return this.applicationProperties.getBaseUrl() + PLUGINS_URI_COMPONENTS;
    }

    private String getBaseImageUrl() {
        return this.webResourceUrlProvider.getStaticResourcePrefix(this.pluginModuleKey, "images/", UrlMode.AUTO);
    }
}

