/*
 * Decompiled with CFR 0.152.
 */
package it.com.atlassian.gadgets.pages.util;

import com.atlassian.pageobjects.elements.PageElement;
import org.openqa.selenium.By;

public final class DashboardGadgets {
    private DashboardGadgets() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static String findGadgetIdByTitle(PageElement dashboardContainer, String gadgetTitle) {
        String id = DashboardGadgets.findGadgetIdByTitleOrNull(dashboardContainer, gadgetTitle);
        if (id == null) {
            throw new IllegalArgumentException("Gadget with title <" + gadgetTitle + "> does not exist");
        }
        return id;
    }

    public static String findGadgetIdByTitleOrNull(PageElement dashboardContainer, String gadgetTitle) {
        for (PageElement titleElem : dashboardContainer.findAll(By.className((String)"dashboard-item-title"))) {
            if (!titleElem.getText().equals(gadgetTitle)) continue;
            return titleElem.getAttribute("id").replace("-title", "");
        }
        return null;
    }

    public static boolean hasGadgetWithTitle(PageElement dashboardContainer, String gadgetTitle) {
        return DashboardGadgets.findGadgetIdByTitleOrNull(dashboardContainer, gadgetTitle) != null;
    }

    public static boolean hasGadgetWithId(PageElement dashboardContainer, String gadgetId) {
        return dashboardContainer.find(By.id((String)(gadgetId + "-renderbox"))).isPresent();
    }
}

