/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal.http;

import com.atlassian.gadgets.opensocial.spi.Whitelist;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;

public class DelegatingWhitelist
implements Whitelist {
    private final Whitelist whitelist;
    private final Iterable<Whitelist> optionalWhitelists;

    public DelegatingWhitelist(Whitelist whitelist, Iterable<Whitelist> optionalWhitelists) {
        this.whitelist = (Whitelist)Preconditions.checkNotNull((Object)whitelist, (Object)"whitelist");
        this.optionalWhitelists = (Iterable)Preconditions.checkNotNull(optionalWhitelists, (Object)"optionalWhitelists");
    }

    public boolean allows(URI uri) {
        return Iterables.any((Iterable)Iterables.concat((Iterable)ImmutableSet.of((Object)this.whitelist), this.optionalWhitelists), this.allowsP((URI)Preconditions.checkNotNull((Object)uri, (Object)"uri")));
    }

    private Predicate<Whitelist> allowsP(URI uri) {
        return new WhitelistAllows(uri);
    }

    private static final class WhitelistAllows
    implements Predicate<Whitelist> {
        private final URI uri;

        public WhitelistAllows(URI uri) {
            this.uri = uri;
        }

        public boolean apply(Whitelist whitelist) {
            return whitelist.allows(this.uri);
        }
    }
}

