/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal;

import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserManager;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public final class GadgetRequestContextFactoryImpl
implements GadgetRequestContextFactory {
    static final String IGNORE_CACHE_PROPERTY_KEY = "com.atlassian.gadgets.dashboard.ignoreCache";
    static final String DEBUG_PROPERTY_KEY = "com.atlassian.gadgets.debug";
    private final LocaleResolver localeResolver;
    private final UserManager userManager;

    @Autowired
    public GadgetRequestContextFactoryImpl(@ComponentImport LocaleResolver localeResolver, @ComponentImport UserManager userManager) {
        this.localeResolver = localeResolver;
        this.userManager = userManager;
    }

    public GadgetRequestContext get(HttpServletRequest request) {
        Locale locale = this.localeResolver.getLocale(request);
        String viewer = this.userManager.getRemoteUsername(request);
        return GadgetRequestContext.Builder.gadgetRequestContext().locale(locale).ignoreCache(this.getCacheSetting(request)).debug(this.isDebugEnabled(request)).viewer(viewer).build();
    }

    private boolean getCacheSetting(HttpServletRequest request) {
        return this.isEnabled(request, "ignoreCache", IGNORE_CACHE_PROPERTY_KEY, false);
    }

    private boolean isDebugEnabled(HttpServletRequest request) {
        return this.isEnabled(request, "debug", DEBUG_PROPERTY_KEY, false);
    }

    private boolean isEnabled(HttpServletRequest request, String parameterName, String propertyName, boolean defaultValue) {
        Boolean enabled = BooleanUtils.toBooleanObject((String)request.getParameter(parameterName));
        if (enabled != null) {
            return enabled;
        }
        enabled = BooleanUtils.toBooleanObject((String)System.getProperty(propertyName));
        if (enabled != null) {
            return enabled;
        }
        return defaultValue;
    }
}

