/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import java.util.Map;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="blobCrypter")
@ExportAsService
public class BlobCrypterImpl
implements BlobCrypter {
    private static final String KEY_PREFIX = BlobCrypter.class.getName() + ":";
    private static final int KEY_BYTE_ARRAY_SIZE = 32;
    private final BlobCrypter crypter;
    private final TransactionTemplate txTemplate;

    @Autowired
    public BlobCrypterImpl(@ComponentImport PluginSettingsFactory factory, @ComponentImport TransactionTemplate txTemplate) {
        this.txTemplate = txTemplate;
        this.crypter = new BasicBlobCrypter(this.getKey(factory).getBytes());
    }

    protected String getKey(PluginSettingsFactory factory) {
        final PluginSettings pluginSettings = factory.createGlobalSettings();
        return (String)this.txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                String key = (String)pluginSettings.get(KEY_PREFIX + "key");
                if (key == null) {
                    SecureRandomService randomService = DefaultSecureRandomService.getInstance();
                    byte[] keyBytes = new byte[32];
                    randomService.nextBytes(keyBytes);
                    key = new String(Base64.encode((byte[])keyBytes));
                    pluginSettings.put(KEY_PREFIX + "key", (Object)key);
                }
                return key;
            }
        });
    }

    public Map<String, String> unwrap(String paramString, int paramInt) throws BlobCrypterException {
        return this.crypter.unwrap(paramString, paramInt);
    }

    public String wrap(Map<String, String> paramMap) throws BlobCrypterException {
        return this.crypter.wrap(paramMap);
    }
}

