/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.directory.internal.impl;

import com.atlassian.gadgets.GadgetParsingException;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetSpecProvider;
import com.atlassian.gadgets.directory.Directory;
import com.atlassian.gadgets.directory.internal.impl.AbstractDirectoryEntryProvider;
import com.atlassian.gadgets.directory.internal.impl.GadgetSpecDirectoryEntry;
import com.atlassian.gadgets.spec.GadgetSpecFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GadgetSpecProviderDirectoryEntryProvider
extends AbstractDirectoryEntryProvider<URI> {
    private final Log log = LogFactory.getLog(this.getClass());
    private Iterable<GadgetSpecProvider> gadgetSpecProviders;

    public GadgetSpecProviderDirectoryEntryProvider(GadgetSpecFactory gadgetSpecFactory, Iterable<GadgetSpecProvider> gadgetSpecProviders, @ComponentImport ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        super(gadgetSpecFactory, threadLocalDelegateExecutorFactory);
        this.gadgetSpecProviders = gadgetSpecProviders;
    }

    @Override
    public boolean contains(final URI gadgetSpecUri) {
        return Iterables.any(this.gadgetSpecProviders, (Predicate)new Predicate<GadgetSpecProvider>(){

            public boolean apply(GadgetSpecProvider provider) {
                try {
                    return provider.contains(gadgetSpecUri);
                }
                catch (RuntimeException e) {
                    if (GadgetSpecProviderDirectoryEntryProvider.this.log.isDebugEnabled()) {
                        GadgetSpecProviderDirectoryEntryProvider.this.log.debug((Object)("Could not determine whether " + provider + " contains " + gadgetSpecUri), (Throwable)e);
                    }
                    return false;
                }
            }
        });
    }

    @Override
    protected Iterable<URI> internalEntries() {
        return Iterables.concat((Iterable)Iterables.transform(this.gadgetSpecProviders, (Function)new Function<GadgetSpecProvider, Iterable<URI>>(){

            public Iterable<URI> apply(GadgetSpecProvider provider) {
                try {
                    return provider.entries();
                }
                catch (RuntimeException e) {
                    if (GadgetSpecProviderDirectoryEntryProvider.this.log.isDebugEnabled()) {
                        GadgetSpecProviderDirectoryEntryProvider.this.log.warn((Object)("Could not retrieve directory entries from " + provider), (Throwable)e);
                    } else if (GadgetSpecProviderDirectoryEntryProvider.this.log.isWarnEnabled()) {
                        GadgetSpecProviderDirectoryEntryProvider.this.log.warn((Object)("Could not retrieve directory entries from " + provider + ": " + e.getMessage()));
                    }
                    return Collections.emptySet();
                }
            }
        }));
    }

    @Override
    protected Function<URI, Directory.Entry> convertToLocalizedDirectoryEntry(final GadgetRequestContext gadgetRequestContext) {
        return new Function<URI, Directory.Entry>(){

            public Directory.Entry apply(URI gadgetSpecUri) {
                try {
                    return new GadgetSpecDirectoryEntry(GadgetSpecProviderDirectoryEntryProvider.this.getGadgetSpec(gadgetSpecUri, gadgetRequestContext), false, null);
                }
                catch (GadgetParsingException e) {
                    if (GadgetSpecProviderDirectoryEntryProvider.this.log.isDebugEnabled()) {
                        GadgetSpecProviderDirectoryEntryProvider.this.log.debug((Object)("Couldn't retrieve " + gadgetSpecUri), (Throwable)e);
                    }
                    return null;
                }
            }
        };
    }

    public String toString() {
        return "application-provided gadget specs";
    }
}

