/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.directory.internal;

import com.atlassian.gadgets.util.HttpTimeoutsProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.codehaus.httpcache4j.cache.CacheStorage;
import org.codehaus.httpcache4j.cache.HTTPCache;
import org.codehaus.httpcache4j.cache.MemoryCacheStorage;
import org.codehaus.httpcache4j.resolver.HTTPClientResponseResolver;
import org.codehaus.httpcache4j.resolver.ResponseResolver;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpCache
extends HTTPCache
implements DisposableBean {
    private final HttpClient client;
    private final HttpTimeoutsProvider httpTimeoutsProvider;

    @Autowired
    public HttpCache(@ComponentImport ApplicationProperties applicationProperties) {
        super((CacheStorage)new MemoryCacheStorage());
        this.httpTimeoutsProvider = new HttpTimeoutsProvider(applicationProperties);
        this.client = this.createHttpClient();
        this.setResolver((ResponseResolver)new HTTPClientResponseResolver(this.client));
    }

    private HttpClient createHttpClient() {
        SchemeRegistry registry = this.createRegistry();
        HttpParams params = this.createHttpParams();
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(params, registry){

            protected void finalize() throws Throwable {
            }
        };
        return new DefaultHttpClient((ClientConnectionManager)connectionManager, params);
    }

    private SchemeRegistry createRegistry() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        return registry;
    }

    private HttpParams createHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Atlassian-Gadgets-HttpClient");
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.httpTimeoutsProvider.getSocketTimeout());
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.httpTimeoutsProvider.getConnectionTimeout());
        return params;
    }

    public void destroy() {
        this.client.getConnectionManager().shutdown();
    }
}

