/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest.representations;

import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardUrlBuilder;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.rest.representations.DashboardRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.RepresentationFactory;
import com.atlassian.gadgets.view.RenderedGadgetUriBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepresentationFactoryImpl
implements RepresentationFactory {
    private final RenderedGadgetUriBuilder renderedGadgetUriBuilder;
    private final DashboardUrlBuilder dashboardUrlBuilder;

    @Autowired
    public RepresentationFactoryImpl(@ComponentImport RenderedGadgetUriBuilder renderedGadgetUriBuilder, DashboardUrlBuilder dashboardUrlBuilder) {
        this.renderedGadgetUriBuilder = renderedGadgetUriBuilder;
        this.dashboardUrlBuilder = dashboardUrlBuilder;
    }

    @Override
    public DashboardRepresentation createDashboardRepresentation(Dashboard dashboard, GadgetRequestContext gadgetRequestContext, boolean writable) {
        ArrayList<GadgetRepresentation> gadgets = new ArrayList<GadgetRepresentation>();
        for (DashboardState.ColumnIndex index : dashboard.getLayout().getColumnRange()) {
            for (Gadget gadget : dashboard.getGadgetsInColumn(index)) {
                gadgets.add(this.createGadgetRepresentation(dashboard.getId(), gadget, gadgetRequestContext, writable, index));
            }
        }
        return new DashboardRepresentation.Builder(dashboard).writable(writable).gadgets(gadgets).build();
    }

    @Override
    public GadgetRepresentation createGadgetRepresentation(DashboardId dashboardId, Gadget gadget, GadgetRequestContext gadgetRequestContext, boolean writable, DashboardState.ColumnIndex column) {
        GadgetRepresentation.GadgetUrlContainer gadgetUrls = new GadgetRepresentation.GadgetUrlContainer(this.renderedGadgetUriBuilder, this.dashboardUrlBuilder, dashboardId, gadget, gadgetRequestContext, writable);
        return new GadgetRepresentation(gadget, gadgetUrls, column);
    }
}

