/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest.representations;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.internal.DashboardUrlBuilder;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.rest.representations.UserPrefsRepresentation;
import com.atlassian.gadgets.view.ModuleId;
import com.atlassian.gadgets.view.RenderedGadgetUriBuilder;
import com.atlassian.gadgets.view.View;
import com.atlassian.gadgets.view.ViewType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
public class GadgetRepresentation {
    @XmlElement
    private final String id;
    @XmlElement
    private final String title;
    @XmlElement
    private final String titleUrl;
    @XmlElement
    private final String gadgetSpecUrl;
    @XmlElement
    private final Integer height;
    @XmlElement
    private final Integer width;
    @XmlElement
    private final Color color;
    @XmlElement
    private final Integer column;
    @XmlElement
    private final String colorUrl;
    @XmlElement
    private final String gadgetUrl;
    @XmlElement
    private final Boolean isMaximizable;
    @XmlElement
    private final String renderedGadgetUrl;
    @XmlElement
    private final Boolean hasNonHiddenUserPrefs;
    @XmlElement
    private final UserPrefsRepresentation userPrefs;
    @XmlElement
    private final Boolean loaded;
    @XmlElement
    private final String errorMessage;

    private GadgetRepresentation() {
        this.id = "0";
        this.title = null;
        this.titleUrl = null;
        this.gadgetSpecUrl = null;
        this.height = null;
        this.width = null;
        this.color = null;
        this.isMaximizable = null;
        this.userPrefs = null;
        this.renderedGadgetUrl = null;
        this.colorUrl = null;
        this.gadgetUrl = null;
        this.hasNonHiddenUserPrefs = null;
        this.column = null;
        this.loaded = null;
        this.errorMessage = "";
    }

    GadgetRepresentation(Gadget gadget, GadgetUrlContainer gadgetUrls, DashboardState.ColumnIndex columnIndex) {
        GadgetId gadgetId = gadget.getId();
        this.id = gadgetId.value();
        this.loaded = gadget.isLoaded();
        this.title = this.loaded != false ? gadget.getTitle() : null;
        this.height = this.loaded != false ? gadget.getHeight() : null;
        this.width = this.loaded != false ? gadget.getWidth() : null;
        this.color = this.loaded != false ? gadget.getColor() : null;
        this.isMaximizable = this.loaded != false ? Boolean.valueOf(gadget.isMaximizable()) : null;
        this.userPrefs = this.loaded != false ? new UserPrefsRepresentation(gadget.getUserPrefs(), gadgetUrls.getUserPrefsUri()) : null;
        this.hasNonHiddenUserPrefs = this.loaded != false ? Boolean.valueOf(gadget.hasNonHiddenUserPrefs()) : null;
        this.titleUrl = gadgetUrls.getTitleUri();
        this.gadgetSpecUrl = gadget.getGadgetSpecUrl();
        this.colorUrl = gadgetUrls.getColorUri();
        this.gadgetUrl = gadgetUrls.getGadgetUri();
        this.renderedGadgetUrl = gadgetUrls.getRenderedGadgetUri();
        this.column = columnIndex == null ? null : Integer.valueOf(columnIndex.index());
        this.errorMessage = gadget.getErrorMessage();
    }

    public Boolean getHasNonHiddenUserPrefs() {
        return this.hasNonHiddenUserPrefs;
    }

    public Boolean isLoaded() {
        return this.loaded;
    }

    public Color getColor() {
        return this.color;
    }

    public String getGadgetSpecUrl() {
        return this.gadgetSpecUrl;
    }

    public Integer getHeight() {
        return this.height;
    }

    public String getId() {
        return this.id;
    }

    public Boolean isMaximizable() {
        return this.isMaximizable;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleUrl() {
        return this.titleUrl;
    }

    public UserPrefsRepresentation getUserPrefs() {
        return this.userPrefs;
    }

    public Integer getWidth() {
        return this.width;
    }

    public String getRenderedGadgetUrl() {
        return this.renderedGadgetUrl;
    }

    public String getColorUrl() {
        return this.colorUrl;
    }

    public String getGadgetUrl() {
        return this.gadgetUrl;
    }

    public Boolean hasNonHiddenUserPrefs() {
        return this.hasNonHiddenUserPrefs;
    }

    public Integer getColumn() {
        return this.column;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    static final class GadgetUrlContainer {
        private final String colorUri;
        private final String gadgetUri;
        private final String userPrefsUri;
        private final String renderedGadgetUri;
        private final String titleUri;

        GadgetUrlContainer(@ComponentImport RenderedGadgetUriBuilder renderedGadgetUriBuilder, DashboardUrlBuilder dashboardUrlBuilder, DashboardId dashboardId, Gadget gadget, GadgetRequestContext gadgetRequestContext, boolean writable) {
            GadgetId gadgetId = gadget.getId();
            String titleUrlString = !gadget.isLoaded() || gadget.getTitleUrl() == null ? null : gadget.getTitleUrl().toASCIIString();
            this.titleUri = StringUtils.isNotBlank(titleUrlString) ? titleUrlString : null;
            this.colorUri = dashboardUrlBuilder.buildGadgetColorUrl(dashboardId, gadgetId);
            this.gadgetUri = dashboardUrlBuilder.buildGadgetUrl(dashboardId, gadgetId);
            this.userPrefsUri = dashboardUrlBuilder.buildGadgetUserPrefsUrl(dashboardId, gadgetId);
            View view = new View.Builder().viewType(ViewType.DEFAULT).writable(writable).build();
            this.renderedGadgetUri = renderedGadgetUriBuilder.build(gadget.getState(), ModuleId.valueOf((String)gadget.getId().value()), view, gadgetRequestContext).toASCIIString();
        }

        public String getColorUri() {
            return this.colorUri;
        }

        public String getGadgetUri() {
            return this.gadgetUri;
        }

        public String getRenderedGadgetUri() {
            return this.renderedGadgetUri;
        }

        public String getUserPrefsUri() {
            return this.userPrefsUri;
        }

        public String getTitleUri() {
            return this.titleUri;
        }
    }
}

