/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest.representations;

import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetRepresentation;
import com.atlassian.plugin.util.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public final class DashboardRepresentation {
    @XmlElement
    private final String id;
    @XmlElement
    private final String title;
    @XmlElement
    private final boolean writable;
    @XmlElement
    private final Layout layout;
    @XmlElement
    private final List<GadgetRepresentation> gadgets;

    private DashboardRepresentation() {
        this.id = null;
        this.title = null;
        this.layout = null;
        this.gadgets = new ArrayList<GadgetRepresentation>();
        this.writable = false;
    }

    private DashboardRepresentation(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.layout = builder.layout;
        this.gadgets = builder.gadgets;
        this.writable = builder.writable;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public List<GadgetRepresentation> getGadgets() {
        return this.gadgets;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public static class Builder {
        private final String id;
        private final String title;
        private final Layout layout;
        private List<GadgetRepresentation> gadgets = Collections.emptyList();
        private boolean writable = false;

        public Builder(Dashboard dashboard) {
            this.id = dashboard.getId().toString();
            this.title = dashboard.getTitle();
            this.layout = dashboard.getLayout();
        }

        public Builder writable(boolean writable) {
            this.writable = writable;
            return this;
        }

        public Builder gadgets(List<GadgetRepresentation> gadgets) {
            Assertions.notNull((String)"gadgets", gadgets);
            this.gadgets = new ArrayList<GadgetRepresentation>(gadgets);
            return this;
        }

        public DashboardRepresentation build() {
            return new DashboardRepresentation(this);
        }
    }
}

