/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardRepository;
import com.atlassian.gadgets.dashboard.internal.InconsistentDashboardStateException;
import com.atlassian.gadgets.dashboard.internal.rest.DeleteGadgetHandler;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteGadgetHandlerImpl
implements DeleteGadgetHandler {
    private final Log log = LogFactory.getLog(DeleteGadgetHandlerImpl.class);
    private final DashboardRepository repository;
    private final I18nResolver i18n;
    private final EventPublisher eventPublisher;

    @Autowired
    public DeleteGadgetHandlerImpl(DashboardRepository repository, @ComponentImport I18nResolver i18n, @ComponentImport EventPublisher eventPublisher) {
        this.repository = repository;
        this.i18n = i18n;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public Response deleteGadget(DashboardId dashboardId, GadgetRequestContext gadgetRequestContext, GadgetId gadgetId) {
        Dashboard dashboard = this.repository.get(dashboardId, gadgetRequestContext);
        dashboard.removeGadget(gadgetId);
        try {
            this.repository.save(dashboard);
        }
        catch (InconsistentDashboardStateException idse) {
            this.log.error((Object)"DeleteGadgetHandlerImpl: Unexpected error occurred", (Throwable)idse);
            return Response.status((Response.Status)Response.Status.CONFLICT).type("text/plain").entity((Object)this.i18n.getText("error.please.reload")).build();
        }
        this.eventPublisher.publish((Object)new GadgetDeletedEvent(dashboardId, gadgetRequestContext.getViewer()));
        return Response.noContent().build();
    }

    public final class GadgetDeletedEvent {
        public final DashboardId dashboardId;
        public final String user;

        public GadgetDeletedEvent(DashboardId dashboardId, String user) {
            this.dashboardId = dashboardId;
            this.user = user;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

