/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest;

import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardRepository;
import com.atlassian.gadgets.dashboard.internal.rest.AddGadgetHandler;
import com.atlassian.gadgets.dashboard.internal.rest.ChangeLayoutHandler;
import com.atlassian.gadgets.dashboard.internal.rest.representations.DashboardRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.RepresentationFactory;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="{dashboardId}")
public class DashboardResource {
    private final Log log = LogFactory.getLog(this.getClass());
    private final DashboardPermissionService permissionService;
    private final GadgetRequestContextFactory gadgetRequestContextFactory;
    private final AddGadgetHandler addGadgetHandler;
    private final ChangeLayoutHandler changeLayoutHandler;
    private final I18nResolver i18n;
    private final DashboardRepository repository;
    private final RepresentationFactory representationFactory;

    public DashboardResource(@ComponentImport DashboardPermissionService permissionService, @ComponentImport GadgetRequestContextFactory gadgetRequestContextFactory, AddGadgetHandler addGadgetHandler, ChangeLayoutHandler changeLayoutHandler, DashboardRepository repository, RepresentationFactory representationFactory, @ComponentImport I18nResolver i18n) {
        this.permissionService = permissionService;
        this.gadgetRequestContextFactory = gadgetRequestContextFactory;
        this.addGadgetHandler = addGadgetHandler;
        this.changeLayoutHandler = changeLayoutHandler;
        this.repository = repository;
        this.representationFactory = representationFactory;
        this.i18n = i18n;
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json", "application/xml"})
    public Response getDashboard(@PathParam(value="dashboardId") DashboardId dashboardId, @Context HttpServletRequest request) {
        this.log.debug((Object)("DashboardResource: GET received: dashboardId = " + dashboardId));
        GadgetRequestContext gadgetRequestContext = this.gadgetRequestContextFactory.get(request);
        if (!this.permissionService.isReadableBy(dashboardId, gadgetRequestContext.getViewer())) {
            this.log.warn((Object)"DashboardResource: GET: prevented getting dashboard representation due to insufficient permission");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Dashboard dashboard = this.repository.get(dashboardId, gadgetRequestContext);
        DashboardRepresentation representation = this.representationFactory.createDashboardRepresentation(dashboard, gadgetRequestContext, this.permissionService.isWritableBy(dashboardId, gadgetRequestContext.getViewer()));
        return Response.ok((Object)representation).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="numGadgets")
    @Produces(value={"text/plain"})
    public Response getNumGadgets(@PathParam(value="dashboardId") DashboardId dashboardId, @Context HttpServletRequest request) {
        this.log.debug((Object)("DashboardResource: GET numGadgets received: " + dashboardId));
        GadgetRequestContext gadgetRequestContext = this.gadgetRequestContextFactory.get(request);
        if (!this.permissionService.isReadableBy(dashboardId, gadgetRequestContext.getViewer())) {
            this.log.warn((Object)"DashboardResource: GET numGadgets: prevented getting number of gadgets on dashboard due to insufficient permission");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Dashboard dashboard = this.repository.get(dashboardId, gadgetRequestContext);
        return Response.ok((Object)String.valueOf(dashboard.getNumberOfGadgets())).build();
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    public Response addGadget(@PathParam(value="dashboardId") DashboardId dashboardId, @Context HttpServletRequest request, Reader jsonContent) {
        DashboardState.ColumnIndex columnIndex;
        String gadgetUrl;
        int columnIndexAsInt = 0;
        try {
            JSONObject jsonObject = new JSONObject(IOUtils.toString((Reader)jsonContent));
            gadgetUrl = jsonObject.optString("url");
            columnIndexAsInt = jsonObject.optInt("columnIndex");
            columnIndex = DashboardState.ColumnIndex.from((int)columnIndexAsInt);
        }
        catch (JSONException jsone) {
            return this.errorParsingJson(jsone);
        }
        catch (IllegalArgumentException iae) {
            this.log.error((Object)("DashboardResource: POST: invalid column index " + columnIndexAsInt + ". Valid values for Column are 0-2."));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)this.i18n.getText("dashboardResource.error.parsing.json", new Serializable[]{iae.getMessage()})).build();
        }
        catch (IOException ioe) {
            this.log.error((Object)"DashboardResource: POST: error reading json entity");
            return Response.serverError().type("text/plain").entity((Object)this.i18n.getText("dashboardResource.error.reading.json", new Serializable[]{ioe.getMessage()})).build();
        }
        GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(request);
        this.log.debug((Object)("DashboardResource: POST received: dashboardId=" + dashboardId + ", url=" + gadgetUrl));
        if (!this.permissionService.isWritableBy(dashboardId, requestContext.getViewer())) {
            this.log.warn((Object)"DashboardResource: POST: prevented gadget addition due to insufficient permission");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.addGadgetHandler.addGadget(dashboardId, requestContext, gadgetUrl, columnIndex);
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Path(value="/layout")
    public Response changeLayoutViaPOST(@PathParam(value="dashboardId") DashboardId dashboardId, @Context HttpServletRequest request, String entity) {
        return this.changeLayout(dashboardId, request, entity);
    }

    @PUT
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Path(value="/layout")
    public Response changeLayoutViaPUT(@PathParam(value="dashboardId") DashboardId dashboardId, @Context HttpServletRequest request, String entity) {
        return this.changeLayout(dashboardId, request, entity);
    }

    private Response changeLayout(DashboardId dashboardId, HttpServletRequest request, String entity) {
        try {
            GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(request);
            this.log.debug((Object)("DashboardResource: changeLayout: dashboardId=" + dashboardId + " viewer=" + requestContext.getViewer()));
            if (!this.permissionService.isWritableBy(dashboardId, requestContext.getViewer())) {
                this.log.warn((Object)"DashboardResource: changeLayout: prevented layout change due to insufficient permission");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return this.changeLayoutHandler.changeLayout(dashboardId, requestContext, new JSONObject(entity));
        }
        catch (JSONException e) {
            return this.errorParsingJson(e);
        }
    }

    private Response errorParsingJson(JSONException e) {
        this.log.warn((Object)"DashboardResource: POST: error parsing json", (Throwable)e);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)this.i18n.getText("dashboardResource.error.parsing.json", new Serializable[]{e.getMessage()})).build();
    }
}

